/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersionImpl;
import org.dspace.versioning.VersioningService;

public class VersioningConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(VersioningConsumer.class);
    private MultiValueMap itemsToProcess;

    public void initialize() throws Exception {
    }

    public void finish(Context ctx) throws Exception {
    }

    public void consume(Context ctx, Event event) throws Exception {
        Bitstream bitstream;
        DSpaceObject dso;
        if (this.itemsToProcess == null) {
            this.itemsToProcess = new MultiValueMap();
        }
        int st = event.getSubjectType();
        int et = event.getEventType();
        if (st == 2 && (et == 64 || et == 2 || et == 4)) {
            Item item = (Item)event.getSubject(ctx);
            this.itemsToProcess.put((Object)item, (Object)event);
        } else if (st == 0 && (et == 2 || et == 4) && (dso = (bitstream = (Bitstream)event.getSubject(ctx)).getParentObject()) != null && dso.getType() == 2) {
            Item item = (Item)dso;
            this.itemsToProcess.put((Object)item, (Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Context ctx) throws Exception {
        if (this.itemsToProcess != null) {
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            for (Object obj : this.itemsToProcess.keySet()) {
                Collection events = this.itemsToProcess.getCollection(obj);
                ctx.turnOffAuthorisationSystem();
                try {
                    Item item = (Item)obj;
                    Boolean addBundles = false;
                    int versionId = 0;
                    if (item != null && item.isArchived()) {
                        String summary = "";
                        summary = this.eventsToString(events).contains("INSTALL") ? "Create New Item" : "Modify Item";
                        VersionImpl version = versioningService.updateVersionHistory(ctx, item, summary, this.eventsToString(events), new Date());
                        if (version.getAIPBitstream() != null) {
                            // empty if block
                        }
                        addBundles = true;
                        versionId = version.getVersionId();
                    }
                    ctx.getDBConnection().commit();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    ctx.restoreAuthSystemState();
                }
            }
            ctx.getDBConnection().commit();
        }
        this.itemsToProcess = null;
    }

    private String eventsToString(Collection<Event> events) {
        String s = "";
        for (Event event : events) {
            s = s + event.toString() + "\n";
        }
        return s;
    }
}

