/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.AIPManifestWriter;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamUtil;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.OREManifestWriter;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.utils.DSpace;
import org.dspace.versioning.DefaultItemVersionProvider;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionDAO;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersionHistoryDAO;
import org.dspace.versioning.VersionHistoryImpl;
import org.dspace.versioning.VersionImpl;
import org.dspace.versioning.VersioningService;
import org.springframework.beans.factory.annotation.Required;

public class VersioningServiceImpl
implements VersioningService {
    private static final Logger log = Logger.getLogger(VersioningServiceImpl.class);
    private VersionHistoryDAO versionHistoryDAO;
    private VersionDAO versionDAO;
    private DefaultItemVersionProvider provider;

    @Override
    public Version createNewWorkingVersionInSubmission(Context c, int itemId, String summary) {
        try {
            Item item = Item.find((Context)c, (int)itemId);
            Date date = new Date();
            if (item == null) {
                VersionHistory history = this.findVersionHistory(c, itemId);
                item = history.getLatestVersion().getItem();
            }
            Item itemNew = this.provider.createNewItemAndAddItInWorkspace(c, item);
            this.provider.updateItemState(c, itemNew, item);
            VersionImpl version = this.updateVersionHistory(c, itemNew, item, summary, "create new version in submission", date);
            return version;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void removeVersion(Context c, int versionID) {
        VersionImpl version = this.versionDAO.find(c, versionID);
        if (version != null) {
            this.removeVersion(c, version);
        }
    }

    @Override
    public void removeVersion(Context c, Item item) {
        VersionImpl version = this.versionDAO.findByItem(c, item);
        if (version != null) {
            this.removeVersion(c, version);
        }
    }

    protected void removeVersion(Context c, Version version) {
        try {
            Bitstream bit;
            Item item;
            VersionHistoryImpl history = this.versionHistoryDAO.findById(c, version.getVersionHistoryID(), this.versionDAO);
            this.provider.deleteVersionedItem(c, version, history);
            this.versionDAO.delete(c, version.getVersionId());
            history.remove(version);
            if (history.isEmpty()) {
                this.versionHistoryDAO.delete(c, version.getVersionHistoryID(), this.versionDAO);
            }
            if ((item = version.getItem()) != null) {
                Collection[] collections;
                for (Collection collection : collections = item.getCollections()) {
                    collection.removeItem(item);
                }
            }
            if ((bit = version.getAIPBitstream()) != null) {
                BitstreamUtil.delete(bit);
            }
        }
        catch (Exception e) {
            c.abort();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public VersionHistory findVersionByHistoryId(Context c, int versionHistoryId) {
        try {
            VersionHistoryImpl history = this.versionHistoryDAO.findById(c, versionHistoryId, this.versionDAO);
            return history;
        }
        catch (Exception e) {
            c.abort();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Version getVersion(Context c, int versionID) {
        return this.versionDAO.find(c, versionID);
    }

    @Override
    public Item restoreVersion(Context c, int versionID) {
        return this.restoreVersion(c, versionID, null);
    }

    @Override
    public Item restoreVersion(Context c, int versionID, String summary) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        Version version = versioningService.getVersion(c, versionID);
        Integer versionHistoryId = version.getVersionHistoryID();
        VersionHistory versionHistory = versioningService.findVersionByHistoryId(c, version.getVersionHistoryID());
        String packageType = "INTERNAL-AIP";
        Bitstream bitstream = version.getAIPBitstream();
        Item newItem = version.getItem();
        if (bitstream != null) {
            Version latestVersionversion = versionHistory.getLatestVersion();
            Item itemToReplace = latestVersionversion.getItem();
            if (!version.equals(latestVersionversion)) {
                PackageIngester sip = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, (String)"INTERNAL-AIP");
                if (sip == null) {
                    return null;
                }
                try {
                    PackageParameters pkgParams = new PackageParameters();
                    File sourceFile = new File("/tmp/version_" + version.getVersionId());
                    sourceFile.createNewFile();
                    String metsFile = "";
                    InputStream inputStream = bitstream.retrieve();
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                    StringBuilder sb = new StringBuilder();
                    FileOutputStream outputStream = new FileOutputStream(sourceFile);
                    int read = 0;
                    byte[] bytes = new byte[1024];
                    while ((read = inputStream.read(bytes)) != -1) {
                        ((OutputStream)outputStream).write(bytes, 0, read);
                    }
                    pkgParams.setProperty("manifestOnly", "true");
                    pkgParams.setProperty("internal", "true");
                    newItem = (Item)sip.replace(c, (DSpaceObject)itemToReplace, sourceFile, pkgParams);
                    Date date = new Date();
                    VersionImpl newVerison = this.updateVersionHistory(c, newItem, summary, "", date, true);
                    c.getDBConnection().commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    c.abort();
                    System.out.println(e);
                }
            }
        }
        return newItem;
    }

    @Override
    public VersionHistory findVersionHistory(Context c, int itemId) {
        return this.versionHistoryDAO.find(c, itemId, this.versionDAO);
    }

    @Override
    public Version updateVersion(Context c, int itemId, String summary) {
        VersionImpl version = this.versionDAO.findByItemId(c, itemId);
        version.setSummary(summary);
        this.versionDAO.update(version);
        return version;
    }

    @Override
    public Version updateVersionByVersionId(Context c, int itemId, int versionId, String summary) {
        VersionImpl version = this.versionDAO.find(c, versionId);
        version.setSummary(summary);
        this.versionDAO.update(version);
        return version;
    }

    @Override
    public Version getVersion(Context c, Item item) {
        return this.versionDAO.findByItemId(c, item.getID());
    }

    @Override
    public VersionImpl updateVersionHistory(Context c, Item item, String summary, String log, Date date) {
        return this.updateVersionHistory(c, item, null, summary, log, date, false);
    }

    @Override
    public VersionImpl updateVersionHistory(Context c, Item item, String summary, String log, Date date, boolean restoreMod) {
        return this.updateVersionHistory(c, item, null, summary, log, date, restoreMod);
    }

    @Override
    public VersionImpl updateVersionHistory(Context c, Item newItem, Item previousItem, String summary, String log, Date date) {
        return this.updateVersionHistory(c, newItem, previousItem, summary, log, date, false);
    }

    public VersionImpl updateVersionHistory(Context c, Item newItem, Item previousItem, String summary, String logs, Date date, boolean restoreMode) {
        VersionImpl versionImpl = null;
        try {
            VersionHistory history = null;
            history = this.findVersionHistory(c, newItem.getID());
            if (history == null && previousItem != null && (history = this.findVersionHistory(c, previousItem.getID())) == null) {
                VersionImpl origVersion = this.updateVersionHistory(c, previousItem, "Original Version", "", date);
                history = this.findVersionHistory(c, previousItem.getID());
            }
            if (history == null) {
                history = this.versionHistoryDAO.create(c);
            }
            if ((versionImpl = this.versionDAO.findByItem(c, newItem)) == null || versionImpl.getVersionNumber() != -1 || restoreMode) {
                if (previousItem == null && history != null) {
                    previousItem = history.getLatestVersion().getItem();
                }
                versionImpl = this.versionDAO.create(c, newItem.getID(), !newItem.isArchived() && !newItem.isWithdrawn());
                versionImpl.setVersionDate(date);
                versionImpl.setEperson(newItem.getSubmitter());
                versionImpl.setItemID(newItem.getID());
                if (newItem.getHandle() != null) {
                    versionImpl.setHandle(newItem.getHandle());
                }
                versionImpl.setSummary(summary);
                versionImpl.setVersionLog(logs);
                if (restoreMode) {
                    versionImpl.setVersionNumber(-1);
                }
                history.add((Version)versionImpl);
                versionImpl.setVersionHistory(history.getVersionHistoryId());
                this.versionDAO.update(versionImpl);
            } else if (!newItem.isArchived() && !newItem.isWithdrawn()) {
                versionImpl.setVersionNumber(-1);
            } else {
                if (previousItem == null) {
                    previousItem = history.getLatestVersion().getItem();
                }
                try {
                    if (previousItem != null && previousItem.getID() != newItem.getID()) {
                        previousItem.setDiscoverable(false);
                        previousItem.update();
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                versionImpl.setVersionNumber(this.getNextVersionNumer(history.getLatestVersion()));
            }
            if (newItem.isArchived() && !newItem.isWithdrawn() && versionImpl.getAIPBitstream() == null && !restoreMode) {
                AIPManifestWriter aipManifestWriter = new AIPManifestWriter();
                Bitstream bitstream = aipManifestWriter.updateAIP(c, (DSpaceObject)newItem, true);
                versionImpl.setAIPBitstream(bitstream.getID());
                AuthorizeManager.inheritPolicies((Context)c, (DSpaceObject)newItem, (DSpaceObject)bitstream);
                OREManifestWriter oreManifestWriter = new OREManifestWriter();
                Bitstream b = oreManifestWriter.updateORE(c, newItem, versionImpl, true);
                versionImpl.setOREBitstream(b.getID());
                AuthorizeManager.inheritPolicies((Context)c, (DSpaceObject)newItem, (DSpaceObject)b);
                VersionDAO.addBitstreams(c, versionImpl.getVersionId(), newItem.getBundles());
            }
            if (summary != null && summary.length() > 0 && (versionImpl.getSummary() == null || versionImpl.getSummary().length() == 0)) {
                versionImpl.setSummary(summary);
            }
            if (logs != null && summary.length() > 0 && (versionImpl.getVerisonLog() == null || versionImpl.getVerisonLog().length() == 0)) {
                versionImpl.setVersionLog(logs);
            }
            if (newItem.getHandle() != null) {
                versionImpl.setHandle(newItem.getHandle());
            } else if (previousItem.getHandle() != null) {
                versionImpl.setHandle(previousItem.getHandle());
            }
            this.versionDAO.update(versionImpl);
            return versionImpl;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return versionImpl;
        }
    }

    protected int getNextVersionNumer(Version latest) {
        if (latest == null) {
            return 1;
        }
        return latest.getVersionNumber() + 1;
    }

    public VersionHistoryDAO getVersionHistoryDAO() {
        return this.versionHistoryDAO;
    }

    public void setVersionHistoryDAO(VersionHistoryDAO versionHistoryDAO) {
        this.versionHistoryDAO = versionHistoryDAO;
    }

    public VersionDAO getVersionDAO() {
        return this.versionDAO;
    }

    public void setVersionDAO(VersionDAO versionDAO) {
        this.versionDAO = versionDAO;
    }

    @Required
    public void setProvider(DefaultItemVersionProvider provider) {
        this.provider = provider;
    }

    @Override
    public boolean canVersion(Context c, Item item) {
        boolean canVersion = false;
        try {
            if (AuthorizeManager.isAdmin((Context)c, (DSpaceObject)item.getOwningCollection()) || AuthorizeManager.authorizeActionBoolean((Context)c, (DSpaceObject)item, (int)1, (boolean)false) || item.getSubmitter().equals((Object)c.getCurrentUser())) {
                canVersion = true;
            } else {
                for (DSpaceObject parentObject = item.getParentObject(); parentObject != null && parentObject.getType() != 5; parentObject = parentObject.getParentObject()) {
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return canVersion;
    }

    public void setVersionLog(VersionImpl version, String versionLog) {
        version.setVersionLog(versionLog);
    }
}

