/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.rest.api;

import com.sun.jersey.multipart.FormDataParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Log;
import org.dataone.service.types.v1.LogEntry;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectInfo;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dspace.app.util.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.dataone.DataOneUtil;
import org.dspace.dataone.statistics.DataOneSolrLogger;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierService;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.utils.DSpace;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class D1MemberNode {
    Node node;
    DataOneSolrLogger dataOneSolrLogger = new DataOneSolrLogger();
    Logger log = Logger.getLogger(D1MemberNode.class);
    private static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    static SimpleDateFormat dateFormatUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static DateTimeFormatter formatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private HttpSolrServer solr = null;

    @Autowired
    public void setNode(Node node) {
        this.node = node;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/xml"})
    public Node doRootV1Ping() throws NotImplemented, ServiceFailure, InsufficientResources {
        return this.doPing();
    }

    @GET
    @Path(value="/v1")
    @Produces(value={"application/xml"})
    public Node doRootPing() throws NotImplemented, ServiceFailure, InsufficientResources {
        return this.doPing();
    }

    @GET
    @Path(value="/v1/monitor/ping")
    @Produces(value={"application/xml"})
    public Node doPing() throws NotImplemented, ServiceFailure, InsufficientResources {
        try {
            Connection connection = DatabaseManager.getConnection();
            if (connection == null) {
                throw new ServiceFailure("sql", "database connection failed");
            }
        }
        catch (Exception e) {
            throw new ServiceFailure("2042", e.getMessage());
        }
        this.node.getPing().setLastSuccess(new Date());
        return this.node;
    }

    @GET
    @Path(value="/v1/node")
    @Produces(value={"application/xml"})
    public Node getCapabilities() throws NotImplemented, ServiceFailure {
        if (this.node != null) {
            return this.node;
        }
        throw new ServiceFailure("2042", "mnCore is null");
    }

    @GET
    @Path(value="/v1/log")
    @Produces(value={"application/xml"})
    public Log getLogRecords(@QueryParam(value="fromDate") String fromDate, @QueryParam(value="toDate") String toDate, @QueryParam(value="event") String event, @QueryParam(value="pidFilter") String pidFilter, @DefaultValue(value="0") @QueryParam(value="start") Integer start, @DefaultValue(value="1000") @QueryParam(value="count") Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        try {
            Log log = new Log();
            QueryResponse result = this.dataOneSolrLogger.getLogRecords(fromDate != null ? new DateTime((Object)fromDate).toDate() : null, toDate != null ? new DateTime((Object)toDate).toDate() : null, event, pidFilter, start.intValue(), count.intValue());
            SolrDocumentList list = result.getResults();
            log.setCount(list.size());
            log.setStart((int)list.getStart());
            log.setTotal((int)list.getNumFound());
            for (SolrDocument doc : list) {
                LogEntry entry = new LogEntry();
                Identifier identifier = new Identifier();
                identifier.setValue(doc.get((Object)"identifier").toString());
                entry.setIdentifier(identifier);
                entry.setDateLogged((Date)doc.get((Object)"dateLogged"));
                entry.setEntryId(doc.get((Object)"entryId").toString());
                entry.setEvent(Event.valueOf((String)doc.get((Object)"event").toString()));
                entry.setIpAddress(doc.get((Object)"ipAddress").toString());
                NodeReference ref = new NodeReference();
                ref.setValue("urn:node:DSPACE");
                entry.setNodeIdentifier(ref);
                Subject subject = new Subject();
                subject.setValue(doc.get((Object)"subject").toString());
                entry.setSubject(subject);
                entry.setUserAgent(doc.get((Object)"userAgent").toString());
                log.addLogEntry(entry);
            }
            return log;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            throw new ServiceFailure("1490", e.getMessage());
        }
    }

    @GET
    @Path(value="/v1/object/{pid: (.*)+}")
    public Response getObject(@Context HttpServletRequest request, @PathParam(value="pid") String pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        DSpaceObject object;
        block12: {
            DSpace dspace = new DSpace();
            org.dspace.core.Context context = ContextUtil.obtainContext(request);
            IdentifierService identifierService = (IdentifierService)dspace.getSingletonService(IdentifierService.class);
            object = identifierService.resolve(context, pid);
            if (object == null || !(object instanceof Bitstream)) break block12;
            Bitstream bitstream = (Bitstream)object;
            if (BitstreamUtil.isDeleted((Bitstream)bitstream)) {
                throw new NotFound("1020", pid + " Not Found (Deleted)");
            }
            if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)bitstream, (int)0)) {
                throw new NotAuthorized("1000", "Not Authorized to Access");
            }
            Response response = Response.ok((Object)bitstream.retrieve()).type(bitstream.getFormat().getMIMEType()).header("Content-Disposition", (Object)this.createDispositionHeader(bitstream, pid)).build();
            this.logEvent(request, pid, Event.READ);
            Response response2 = response;
            return response2;
        }
        try {
            if (object != null) {
                throw new NotImplemented("1001", "Unsupported Object Type " + object.getClass().getName());
            }
            throw new NotFound("1020", pid + " Not Found");
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
            throw new ServiceFailure("1030", e.getMessage());
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            throw new ServiceFailure("1030", e.getMessage());
        }
        catch (AuthorizeException e) {
            this.log.error((Object)e.getMessage());
            throw new NotAuthorized("1000", "Not Authorized to Access " + e.getMessage());
        }
        catch (IdentifierNotResolvableException e) {
            this.log.error((Object)e.getMessage());
            throw new NotFound("1020", pid + " Not Found: " + e.getMessage());
        }
        catch (IdentifierNotFoundException e) {
            this.log.error((Object)e.getMessage());
            throw new NotFound("1020", pid + " Not Found: " + e.getMessage());
        }
    }

    @GET
    @Path(value="/v1/meta/{pid: (.*)+}")
    @Produces(value={"application/xml"})
    public SystemMetadata getSystemMetadata(@Context HttpServletRequest request, @PathParam(value="pid") String pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        try {
            DSpace dspace = new DSpace();
            org.dspace.core.Context context = ContextUtil.obtainContext(request);
            IdentifierService identifierService = (IdentifierService)dspace.getSingletonService(IdentifierService.class);
            DSpaceObject object = identifierService.resolve(context, pid);
            if (object != null && object instanceof Bitstream) {
                Bitstream obsoleteBitstream;
                Bitstream bitstream = (Bitstream)object;
                String mimeType = bitstream.getFormat().getMIMEType();
                this.log.debug((Object)("Setting data file MIME type to: " + mimeType));
                String name = bitstream.getName();
                SystemMetadata systemMetadata = new SystemMetadata();
                systemMetadata.setSize(BigInteger.valueOf(bitstream.getSize()));
                Checksum checksum = new Checksum();
                checksum.setValue(bitstream.getChecksum());
                checksum.setAlgorithm(bitstream.getChecksumAlgorithm());
                systemMetadata.setChecksum(checksum);
                DSpaceObject parent = bitstream.getParentObject();
                if (parent != null && parent instanceof Item && ((Item)parent).isWithdrawn()) {
                    systemMetadata.setArchived(Boolean.valueOf(true));
                } else {
                    systemMetadata.setArchived(Boolean.valueOf(BitstreamUtil.isDeleted((Bitstream)bitstream)));
                }
                Identifier identifier = new Identifier();
                identifier.setValue(pid);
                systemMetadata.setIdentifier(identifier);
                Subject subject = new Subject();
                subject.setValue("test");
                systemMetadata.setRightsHolder(subject);
                AccessPolicy ap = new AccessPolicy();
                for (ResourcePolicy rp : AuthorizeManager.getPoliciesActionFilter((org.dspace.core.Context)context, (DSpaceObject)bitstream, (int)0)) {
                    if (rp == null || rp.getGroupID() != 0) continue;
                    AccessRule ar = new AccessRule();
                    Subject pub = new Subject();
                    pub.setValue("public");
                    ar.setSubjectList(Collections.singletonList(pub));
                    ar.setPermissionList(Collections.singletonList(Permission.READ));
                    ap.setAllowList(Collections.singletonList(ar));
                }
                systemMetadata.setAccessPolicy(ap);
                Bitstream obsoletedByBitstream = BitstreamUtil.getObsoletedBy((org.dspace.core.Context)context, (Bitstream)bitstream);
                if (obsoletedByBitstream != null) {
                    Identifier obsoletedByIdentifier = new Identifier();
                    obsoletedByIdentifier.setValue(DataOneUtil.getPid((Bitstream)obsoletedByBitstream));
                    systemMetadata.setObsoletedBy(obsoletedByIdentifier);
                }
                if ((obsoleteBitstream = BitstreamUtil.getObsoletes((org.dspace.core.Context)context, (Bitstream)bitstream)) != null) {
                    Identifier obsoleteIdentifier = new Identifier();
                    obsoleteIdentifier.setValue(DataOneUtil.getPid((Bitstream)obsoleteBitstream));
                    systemMetadata.setObsoletes(obsoleteIdentifier);
                }
                ObjectFormatIdentifier objectFormatIdentifier = new ObjectFormatIdentifier();
                objectFormatIdentifier.setValue(DataOneUtil.getFormat((Bitstream)bitstream));
                systemMetadata.setFormatId(objectFormatIdentifier);
                systemMetadata.setDateSysMetadataModified(BitstreamUtil.getLastModifiedDate((org.dspace.core.Context)context, (Bitstream)bitstream));
                systemMetadata.setDateUploaded(BitstreamUtil.getDateCreated((org.dspace.core.Context)context, (Bitstream)bitstream));
                return systemMetadata;
            }
            if (object != null) {
                throw new NotImplemented("1041", "Unsupported Object Type " + object.getClass().getName());
            }
            throw new NotFound("1060", pid + " Not Found");
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            throw new ServiceFailure("1090", e.getMessage());
        }
        catch (IdentifierNotResolvableException e) {
            this.log.error((Object)e.getMessage());
            throw new NotFound("1060", pid + " Not Found: " + e.getMessage());
        }
        catch (IdentifierNotFoundException e) {
            this.log.error((Object)e.getMessage());
            throw new NotFound("1060", pid + " Not Found: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            throw new NotFound("1060", pid + " Not Found: " + e.getMessage());
        }
    }

    @HEAD
    @Path(value="/v1/object/{pid: (.*)+}")
    @Produces(value={"application/xml"})
    public Response getDescribeObject(@Context HttpServletRequest request, @PathParam(value="pid") String pid) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        try {
            SystemMetadata systemMetadata = this.getSystemMetadata(request, pid);
            Response.ResponseBuilder rb = Response.ok();
            rb = rb.header("Content-Length", (Object)systemMetadata.getSize().toString());
            rb = rb.header("Content-Type", (Object)systemMetadata.getFormatId().getValue());
            if (systemMetadata.getDateUploaded() != null) {
                rb = rb.header("Last-Modified", (Object)format.format(systemMetadata.getDateUploaded()));
            }
            rb = rb.header("DataONE-formatId", (Object)systemMetadata.getFormatId().getValue());
            rb = rb.header("DataONE-Checksum", (Object)(systemMetadata.getChecksum().getAlgorithm() + "," + systemMetadata.getChecksum().getValue()));
            rb = rb.header("DataONE-SerialVersion", (Object)(systemMetadata.getSerialVersion() != null ? systemMetadata.getSerialVersion().toString() : "1"));
            return rb.build();
        }
        catch (NotFound notFound) {
            throw new NotFound("1380", notFound.getMessage());
        }
        catch (InvalidToken invalidToken) {
            throw new InvalidToken("1370", invalidToken.getMessage());
        }
        catch (NotAuthorized notAuthorized) {
            throw new NotAuthorized("1360", notAuthorized.getMessage());
        }
        catch (NotImplemented notImplemented) {
            throw new NotImplemented("1361", notImplemented.getMessage());
        }
        catch (ServiceFailure serviceFailure) {
            throw new ServiceFailure("1390", serviceFailure.getMessage());
        }
    }

    @GET
    @Path(value="/v1/checksum/{pid: (.*)+}")
    @Produces(value={"application/xml"})
    public Checksum getChecksum(@Context HttpServletRequest request, @PathParam(value="pid") String pid, @QueryParam(value="checksumAlgorithm") String checksumAlgorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        try {
            DSpace dspace = new DSpace();
            org.dspace.core.Context context = ContextUtil.obtainContext(request);
            IdentifierService identifierService = (IdentifierService)dspace.getSingletonService(IdentifierService.class);
            DSpaceObject object = identifierService.resolve(context, pid);
            if (object != null && object instanceof Bitstream) {
                Bitstream bitstream = (Bitstream)object;
                boolean isAuthorized = AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)bitstream, (int)0);
                if (!isAuthorized) {
                    throw new NotAuthorized("1400", "Not Authorized to Access");
                }
                Checksum checksum = new Checksum();
                checksum.setValue(bitstream.getChecksum());
                checksum.setAlgorithm(bitstream.getChecksumAlgorithm());
                return checksum;
            }
            if (object != null) {
                throw new NotImplemented("1401", "Unsupported Object Type " + object.getClass().getName());
            }
            throw new NotFound("1420", pid + " Not Found");
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            throw new ServiceFailure("1410", e.getMessage());
        }
        catch (IdentifierNotResolvableException e) {
            this.log.error((Object)e.getMessage());
            throw new NotFound("1420", pid + " Not Found: " + e.getMessage());
        }
        catch (IdentifierNotFoundException e) {
            this.log.error((Object)e.getMessage());
            throw new NotFound("1420", pid + " Not Found: " + e.getMessage());
        }
    }

    @GET
    @Path(value="/v1/object")
    @Produces(value={"application/xml"})
    public ObjectList listObjects(@QueryParam(value="identifier") String identifier, @QueryParam(value="fromDate") String fromDate, @QueryParam(value="toDate") String toDate, @QueryParam(value="formatId") String formatId, @QueryParam(value="replicaStatus") Boolean replicaStatus, @QueryParam(value="start") Integer start, @QueryParam(value="count") Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        QueryResponse results = null;
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery("*:*");
            solrQuery.addFilterQuery(new String[]{"search.resourcetype:0"});
            solrQuery.addFilterQuery(new String[]{"deleted_b:false"});
            solrQuery.addSort(new SolrQuery.SortClause("dateSysMetadataModified_dt", SolrQuery.ORDER.desc));
            if (identifier != null) {
                solrQuery.addFilterQuery(new String[]{"identifier_s:" + ClientUtils.escapeQueryChars((String)identifier)});
            }
            if (formatId != null) {
                if ("http://www.openarchives.org/ore/terms/".contains(formatId)) {
                    formatId = "http://www.openarchives.org/ore/terms/";
                }
                solrQuery.addFilterQuery(new String[]{"formatId_s:" + ClientUtils.escapeQueryChars((String)formatId)});
            }
            if (replicaStatus != null) {
                solrQuery.addFilterQuery(new String[]{"replicaStatus:" + replicaStatus});
            }
            if (fromDate != null && toDate != null) {
                solrQuery.addFilterQuery(new String[]{"dateSysMetadataModified_dt:[" + this.parseDate(fromDate) + " TO " + this.parseDate(toDate) + "}"});
            } else if (fromDate != null) {
                solrQuery.addFilterQuery(new String[]{"dateSysMetadataModified_dt:[" + this.parseDate(fromDate) + " TO *}"});
            } else if (toDate != null) {
                solrQuery.addFilterQuery(new String[]{"dateSysMetadataModified_dt:[* TO " + this.parseDate(toDate) + "}"});
            }
            if (start == null || start < 0) {
                solrQuery.setStart(Integer.valueOf(0));
            } else {
                solrQuery.setStart(start);
            }
            if (count == null || count < 0) {
                solrQuery.setRows(Integer.valueOf(100));
            } else {
                solrQuery.setRows(count);
            }
            results = this.getSolr().query((SolrParams)solrQuery);
        }
        catch (SolrServerException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new InvalidRequest("1540", e.getMessage());
        }
        ObjectList objectList = new ObjectList();
        if (results != null) {
            SolrDocumentList solrDocuments = results.getResults();
            objectList.setTotal((int)solrDocuments.getNumFound());
            objectList.setCount(solrDocuments.size());
            objectList.setStart((int)solrDocuments.getStart());
            for (SolrDocument solrDocument : solrDocuments) {
                String id = (String)solrDocument.getFirstValue("identifier_s");
                String format = (String)solrDocument.getFirstValue("formatId_s");
                Date dateSysMetadataModified = (Date)solrDocument.getFirstValue("dateSysMetadataModified_dt");
                Long size = (Long)solrDocument.getFirstValue("size_l");
                String checksum = (String)solrDocument.getFirstValue("checksum_s");
                ObjectInfo objectInfo = new ObjectInfo();
                Identifier identifierObj = new Identifier();
                identifierObj.setValue(id != null ? id : "null");
                objectInfo.setIdentifier(identifierObj);
                ObjectFormatIdentifier objectFormat = new ObjectFormatIdentifier();
                objectFormat.setValue(format != null ? format : "octet/stream");
                objectInfo.setFormatId(objectFormat);
                try {
                    objectInfo.setDateSysMetadataModified(dateSysMetadataModified != null ? dateSysMetadataModified : new Date());
                }
                catch (Exception e) {
                    this.log.debug((Object)e.getMessage(), (Throwable)e);
                }
                BigInteger sizeObject = new BigInteger(size != null && size > 0L ? size.toString() : "0");
                objectInfo.setSize(sizeObject);
                Checksum checksumObject = new Checksum();
                checksumObject.setValue(checksum == null || "0".equals(size) ? "d41d8cd98f00b204e9800998ecf8427e" : checksum);
                checksumObject.setAlgorithm("MD5");
                objectInfo.setChecksum(checksumObject);
                objectList.addObjectInfo(objectInfo);
            }
        }
        return objectList;
    }

    private String parseDate(String date) {
        return formatter.print((ReadableInstant)new DateTime((Object)date));
    }

    @POST
    @Path(value="/v1/error")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/xml"})
    public Response synchronizationFailed(@Context HttpServletRequest request, @FormDataParam(value="message") InputStream message) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)message, (Writer)writer);
            this.log.error((Object)writer.getBuffer().toString());
            try {
                if (ConfigurationManager.getProperty((String)"dataone", (String)"error.recipient") != null) {
                    org.dspace.core.Context context = ContextUtil.obtainContext(request);
                    Email email = Email.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"dataone_error"));
                    email.addRecipient(ConfigurationManager.getProperty((String)"dataone", (String)"error.recipient"));
                    email.addArgument((Object)format.format(new Date()));
                    email.addArgument((Object)writer.getBuffer().toString());
                    email.send();
                }
            }
            catch (MessagingException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            return Response.ok().build();
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new ServiceFailure("2161", e.getMessage());
        }
    }

    @GET
    @Path(value="/v1/replica/{pid: (.*)+}")
    public Response getReplica(@Context HttpServletRequest request, @PathParam(value="pid") String pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        try {
            DSpace dspace = new DSpace();
            org.dspace.core.Context context = ContextUtil.obtainContext(request);
            IdentifierService identifierService = (IdentifierService)dspace.getSingletonService(IdentifierService.class);
            DSpaceObject object = identifierService.resolve(context, pid);
            if (object != null && object instanceof Bitstream) {
                Bitstream bitstream = (Bitstream)object;
                if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)bitstream, (int)0)) {
                    throw new NotAuthorized("2182", "Not Authorized to Access");
                }
                Response response = Response.ok((Object)bitstream.retrieve()).type(bitstream.getFormat().getMIMEType()).header("Content-Disposition", (Object)this.createDispositionHeader(bitstream, pid)).build();
                this.logEvent(request, pid, Event.REPLICATE);
                return response;
            }
            if (object != null) {
                throw new NotImplemented("2180", "Unsupported Object Type " + object.getClass().getName());
            }
            throw new NotFound("2185", pid + " Not Found");
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
            throw new ServiceFailure("2181", e.getMessage());
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            throw new ServiceFailure("2181", e.getMessage());
        }
        catch (AuthorizeException e) {
            this.log.error((Object)e.getMessage());
            throw new NotAuthorized("2182", "Not Authorized to Access " + e.getMessage());
        }
        catch (IdentifierNotResolvableException e) {
            this.log.error((Object)e.getMessage());
            throw new NotFound("2185", pid + " Not Found: " + e.getMessage());
        }
        catch (IdentifierNotFoundException e) {
            this.log.error((Object)e.getMessage());
            throw new NotFound("2185", pid + " Not Found: " + e.getMessage());
        }
    }

    @GET
    @Path(value="/v1/query/{queryEngine}/{query}")
    @Produces(value={"application/xml"})
    public InputStream query(@PathParam(value="queryEngine") String queryEngine, @PathParam(value="query") String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        throw new NotImplemented("", "");
    }

    @GET
    @Path(value="/v1/query/{queryType}")
    @Produces(value={"application/xml"})
    public QueryEngineDescription getQueryEngineDescription(@PathParam(value="queryType") String queryEngine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        throw new NotImplemented("", "");
    }

    @GET
    @Path(value="/v1/query")
    @Produces(value={"application/xml"})
    public QueryEngineList listQueryEngines() throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        throw new NotImplemented("", "");
    }

    @GET
    @Path(value="/v1/isAuthorized/{pid}")
    @Produces(value={"application/xml"})
    public boolean isAuthorized(@PathParam(value="pid") String pid, @QueryParam(value="action") String action) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        throw new NotImplemented("", "");
    }

    private HttpSolrServer getSolr() throws ServiceFailure {
        if (this.solr == null) {
            UrlValidator urlValidator = new UrlValidator(8L);
            String solrService = new DSpace().getConfigurationService().getProperty("discovery.search.server");
            if (urlValidator.isValid(solrService)) {
                try {
                    this.log.debug((Object)("Solr URL: " + solrService));
                    this.solr = new HttpSolrServer(solrService);
                    this.solr.setBaseURL(solrService);
                    SolrQuery solrQuery = new SolrQuery().setQuery("search.resourcetype:2 AND search.resourceid:1");
                    this.solr.query((SolrParams)solrQuery);
                }
                catch (SolrServerException e) {
                    this.log.error((Object)"Error while initializing solr server", (Throwable)e);
                    throw new ServiceFailure("1580", "Solr Is Not Available. " + e.getMessage());
                }
            } else {
                this.log.error((Object)("Error while initializing solr, invalid url: " + solrService));
                throw new ServiceFailure("1580", "Solr Is Not Available. Invalid URL: " + solrService);
            }
        }
        return this.solr;
    }

    private String createDispositionHeader(Bitstream bitstream, String pid) {
        String name = bitstream.getName();
        if (name == null || name.trim().equals("")) {
            name = pid.replace("/", "_").replace(".", "_");
        }
        String ext = "";
        if (!name.contains(".") && bitstream.getFormat() != null && bitstream.getFormat().getExtensions() != null && bitstream.getFormat().getExtensions().length > 0) {
            ext = "." + bitstream.getFormat().getExtensions()[0];
        }
        return "attachment; filename=\"" + name + ext;
    }

    private void logEvent(HttpServletRequest request, String pid, Event event) {
        try {
            this.dataOneSolrLogger.logEvent(request, pid, event.name(), new Date(), this.getCapabilities().getIdentifier().getValue());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

