/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.app.util.ContextUtil;
import org.dspace.app.util.RequestInfo;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class AuthenticationUtil {
    private static final Logger log = Logger.getLogger(AuthenticationUtil.class);
    private static final String CURRENT_IP_ADDRESS = "dspace.user.ip";
    private static final String EFFECTIVE_USER_ID = "dspace.user.effective";
    private static final String AUTHENTICATED_USER_ID = "dspace.user.authenticated";
    public static final String REQUEST_INTERRUPTED = "dspace.request.interrupted";
    public static final String REQUEST_RESUME = "dspace.request.resume";

    public static Context authenticate(HttpServletRequest request, String email, String password, String realm) throws SQLException {
        Context context = ContextUtil.obtainContext(request);
        int implicitStatus = AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.logIn(context, request, context.getCurrentUser());
        } else {
            int explicitStatus = AuthenticationManager.authenticate((Context)context, (String)email, (String)password, (String)realm, (HttpServletRequest)request);
            if (explicitStatus == 1) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=explicit"));
                AuthenticationUtil.logIn(context, request, context.getCurrentUser());
            } else {
                log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("email=" + email + ", realm=" + realm + ", result=" + explicitStatus)));
            }
        }
        return context;
    }

    public static Context authenticateImplicit(HttpServletRequest request) throws SQLException {
        Context context = ContextUtil.obtainContext(request);
        int implicitStatus = AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.logIn(context, request, context.getCurrentUser());
        }
        return context;
    }

    private static void logIn(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
        int[] groupIDs;
        if (eperson == null) {
            return;
        }
        HttpSession session = request.getSession();
        context.setCurrentUser(eperson);
        for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
            context.setSpecialGroup(groupID);
        }
        session.setAttribute(CURRENT_IP_ADDRESS, (Object)request.getRemoteAddr());
        session.setAttribute(EFFECTIVE_USER_ID, (Object)eperson.getID());
        session.setAttribute(AUTHENTICATED_USER_ID, (Object)eperson.getID());
    }

    public static void logIn(HttpServletRequest request, EPerson eperson) throws SQLException {
        Context context = ContextUtil.obtainContext(request);
        AuthenticationUtil.logIn(context, request, eperson);
    }

    public static void resumeLogin(Context context, HttpServletRequest request) throws SQLException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            Integer id = (Integer)session.getAttribute(EFFECTIVE_USER_ID);
            Integer realid = (Integer)session.getAttribute(AUTHENTICATED_USER_ID);
            if (id != null) {
                boolean ipcheck = ConfigurationManager.getBooleanProperty((String)"xmlui.session.ipcheck", (boolean)true);
                String address = (String)session.getAttribute(CURRENT_IP_ADDRESS);
                if (!ipcheck || address != null && address.equals(request.getRemoteAddr())) {
                    int[] groupIDs;
                    EPerson eperson = EPerson.find((Context)context, (int)id);
                    context.setCurrentUser(eperson);
                    for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
                        context.setSpecialGroup(groupID);
                    }
                } else {
                    log.warn((Object)LogManager.getHeader((Context)context, (String)"ip_mismatch", (String)("id=" + id + ", request ip=" + request.getRemoteAddr() + ", session ip=" + address)));
                }
            }
        }
    }

    public static void logOut(Context context, HttpServletRequest request) throws SQLException {
        HttpSession session = request.getSession();
        if (session.getAttribute(EFFECTIVE_USER_ID) != null && session.getAttribute(AUTHENTICATED_USER_ID) != null) {
            Integer effectiveID = (Integer)session.getAttribute(EFFECTIVE_USER_ID);
            Integer authenticatedID = (Integer)session.getAttribute(AUTHENTICATED_USER_ID);
            if (effectiveID.intValue() != authenticatedID.intValue()) {
                EPerson authenticatedUser = EPerson.find((Context)context, (int)authenticatedID);
                context.setCurrentUser(authenticatedUser);
                session.setAttribute(EFFECTIVE_USER_ID, (Object)authenticatedID);
                return;
            }
        }
        context.setCurrentUser(null);
        session.removeAttribute(EFFECTIVE_USER_ID);
        session.removeAttribute(AUTHENTICATED_USER_ID);
        session.removeAttribute(CURRENT_IP_ADDRESS);
    }

    public static boolean isLoggedIn(HttpServletRequest request) {
        return null != request.getSession().getAttribute(EFFECTIVE_USER_ID);
    }

    public static HttpServletRequest resumeRequest(HttpServletRequest realHttpRequest) {
        HttpSession session = realHttpRequest.getSession();
        Object object = session.getAttribute(REQUEST_RESUME);
        if (object instanceof RequestInfo) {
            RequestInfo interruptedRequest = (RequestInfo)object;
            String interruptedServletPath = interruptedRequest.getServletPath();
            String realServletPath = realHttpRequest.getServletPath();
            if (realServletPath != null && realServletPath.equals(interruptedServletPath)) {
                session.setAttribute(REQUEST_INTERRUPTED, null);
                session.setAttribute(REQUEST_RESUME, null);
                return interruptedRequest.wrapRequest(realHttpRequest);
            }
        }
        return realHttpRequest;
    }
}

