/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.app.util.ContextUtil;
import org.dspace.app.util.RequestInfo;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticationUtil {
    private static final Logger log = Logger.getLogger(AuthenticationUtil.class);
    public static final String REQUEST_INTERRUPTED = "dspace.request.interrupted";
    public static final String REQUEST_RESUME = "dspace.request.resume";
    public static final String REQUEST_INTERRUPTED_HEADER = "dspace.request.interrupted.header";
    public static final String REQUEST_INTERRUPTED_MESSAGE = "dspace.request.interrupted.message";
    public static final String REQUEST_INTERRUPTED_CHARACTERS = "dspace.request.interrupted.characters";
    private static final String CURRENT_IP_ADDRESS = "dspace.user.ip";
    private static final String EFFECTIVE_USER_ID = "dspace.user.effective";
    private static final String AUTHENTICATED_USER_ID = "dspace.user.authenticated";

    public static Context authenticate(HttpServletRequest request, String email, String password, String realm) throws SQLException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        int implicitStatus = AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)context.getCurrentUser());
        } else {
            int explicitStatus = AuthenticationManager.authenticate((Context)context, (String)email, (String)password, (String)realm, (HttpServletRequest)request);
            if (explicitStatus == 1) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=explicit"));
                AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)context.getCurrentUser());
            } else {
                log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("email=" + email + ", realm=" + realm + ", result=" + explicitStatus)));
            }
        }
        return context;
    }

    public static Context authenticateImplicit(HttpServletRequest request) throws SQLException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        int implicitStatus = AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)context.getCurrentUser());
        }
        return context;
    }

    private static void logIn(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
        int[] groupIDs;
        if (eperson == null) {
            return;
        }
        HttpSession session = request.getSession();
        context.setCurrentUser(eperson);
        for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
            context.setSpecialGroup(groupID);
        }
        session.setAttribute("dspace.user.ip", (Object)request.getRemoteAddr());
        session.setAttribute("dspace.user.effective", (Object)eperson.getID());
        session.setAttribute("dspace.user.authenticated", (Object)eperson.getID());
    }

    public static void logIn(HttpServletRequest request, EPerson eperson) throws SQLException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)eperson);
    }

    public static void resumeLogin(Context context, HttpServletRequest request) throws SQLException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            Integer id = (Integer)session.getAttribute("dspace.user.effective");
            Integer realid = (Integer)session.getAttribute("dspace.user.authenticated");
            if (id != null) {
                boolean ipcheck = ConfigurationManager.getBooleanProperty((String)"xmlui.session.ipcheck", (boolean)true);
                String address = (String)session.getAttribute("dspace.user.ip");
                if (!ipcheck || address != null && address.equals(request.getRemoteAddr())) {
                    int[] groupIDs;
                    EPerson eperson = EPerson.find((Context)context, (int)id);
                    context.setCurrentUser(eperson);
                    for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
                        context.setSpecialGroup(groupID);
                    }
                } else {
                    log.warn((Object)LogManager.getHeader((Context)context, (String)"ip_mismatch", (String)("id=" + id + ", request ip=" + request.getRemoteAddr() + ", session ip=" + address)));
                }
            }
        }
    }

    public static void logOut(Context context, HttpServletRequest request) throws SQLException {
        HttpSession session = request.getSession();
        if (session.getAttribute("dspace.user.effective") != null && session.getAttribute("dspace.user.authenticated") != null) {
            Integer effectiveID = (Integer)session.getAttribute("dspace.user.effective");
            Integer authenticatedID = (Integer)session.getAttribute("dspace.user.authenticated");
            if (effectiveID.intValue() != authenticatedID.intValue()) {
                EPerson authenticatedUser = EPerson.find((Context)context, (int)authenticatedID);
                context.setCurrentUser(authenticatedUser);
                session.setAttribute("dspace.user.effective", (Object)authenticatedID);
                return;
            }
        }
        context.setCurrentUser(null);
        session.removeAttribute("dspace.user.effective");
        session.removeAttribute("dspace.user.authenticated");
        session.removeAttribute("dspace.user.ip");
    }

    public static boolean isLoggedIn(HttpServletRequest request) {
        return null != request.getSession().getAttribute("dspace.user.effective");
    }

    public static HttpServletRequest resumeRequest(HttpServletRequest realHttpRequest) {
        HttpSession session = realHttpRequest.getSession();
        Object object = session.getAttribute("dspace.request.resume");
        if (object instanceof RequestInfo) {
            RequestInfo interruptedRequest = (RequestInfo)object;
            String interruptedServletPath = interruptedRequest.getServletPath();
            String realServletPath = realHttpRequest.getServletPath();
            if (realServletPath != null && realServletPath.equals(interruptedServletPath)) {
                session.setAttribute("dspace.request.interrupted", null);
                session.setAttribute("dspace.request.resume", null);
                return interruptedRequest.wrapRequest(realHttpRequest);
            }
        }
        return realHttpRequest;
    }
}

