/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthenticationUtil;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class ContextUtil {
    private static Boolean useProxies;
    private static final Logger log;
    public static final String DSPACE_CONTEXT = "dspace.context";

    public static Context obtainContext(HttpServletRequest request) throws SQLException {
        Context context = (Context)request.getAttribute(DSPACE_CONTEXT);
        if (context == null) {
            context = new Context();
            context.setExtraLogInfo("session_id=" + request.getSession().getId());
            AuthenticationUtil.resumeLogin((Context)context, (HttpServletRequest)request);
            int[] groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request);
            for (int i = 0; i < groupIDs.length; ++i) {
                context.setSpecialGroup(groupIDs[i]);
                log.debug((Object)("Adding Special Group id=" + String.valueOf(groupIDs[i])));
            }
            String ip = request.getRemoteAddr();
            if (useProxies == null) {
                useProxies = ConfigurationManager.getBooleanProperty((String)"useProxies", (boolean)false);
            }
            if (useProxies.booleanValue() && request.getHeader("X-Forwarded-For") != null) {
                for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                    if (request.getHeader("X-Forwarded-For").contains(ip)) continue;
                    ip = xfip.trim();
                }
            }
            context.setExtraLogInfo("session_id=" + request.getSession().getId() + ":ip_addr=" + ip);
            request.setAttribute(DSPACE_CONTEXT, (Object)context);
        }
        return context;
    }

    public static void completeContext(HttpServletRequest request) throws ServletException {
        Context context = (Context)request.getAttribute(DSPACE_CONTEXT);
        if (context != null && context.isValid()) {
            try {
                context.complete();
            }
            catch (SQLException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public static void abortContext(HttpServletRequest request) {
        Context context = (Context)request.getAttribute(DSPACE_CONTEXT);
        if (context != null && context.isValid()) {
            context.abort();
        }
    }

    static {
        log = Logger.getLogger(ContextUtil.class);
    }
}

