/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.ContextUtil;

public class DSpaceContextServletFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(DSpaceContextServletFilter.class);
    private static final long serialVersionUID = 1L;

    public void init(FilterConfig arg0) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain arg2) throws IOException, ServletException {
        HttpServletRequest realRequest = (HttpServletRequest)request;
        HttpServletResponse realResponse = (HttpServletResponse)response;
        try {
            arg2.doFilter((ServletRequest)realRequest, (ServletResponse)realResponse);
        }
        catch (IOException e) {
            ContextUtil.abortContext((HttpServletRequest)realRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The connection was reset", (Throwable)e);
            } else {
                LOG.error((Object)"Client closed the connection before file download was complete");
            }
        }
        catch (RuntimeException e) {
            ContextUtil.abortContext((HttpServletRequest)realRequest);
            LOG.error((Object)"Serious Runtime Error Occurred Processing Request!", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ContextUtil.abortContext((HttpServletRequest)realRequest);
            LOG.error((Object)"Serious Error Occurred Processing Request!", (Throwable)e);
        }
        finally {
            ContextUtil.completeContext((HttpServletRequest)realRequest);
        }
    }

    public void destroy() {
    }
}

