/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.dataone.statistics;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.lucene.queryparser.surround.parser.ParseException;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.dspace.core.ConfigurationManager;

public class DataOneSolrLogger {
    private final HttpSolrServer solr;
    static Logger log = Logger.getLogger(DataOneSolrLogger.class);
    static SimpleDateFormat dateFormatUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final String LUCENE_ESCAPE_CHARS = "[\\\\+\\-\\!\\(\\)\\:\\^\\]\\{\\}\\~\\*\\?\\/]";
    private static final Pattern LUCENE_PATTERN = Pattern.compile("[\\\\+\\-\\!\\(\\)\\:\\^\\]\\{\\}\\~\\*\\?\\/]");
    private static final String REPLACEMENT_STRING = "\\\\$0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataOneSolrLogger() {
        String serverString = ConfigurationManager.getProperty((String)"dataone", (String)"server");
        log.info((Object)("dataone.server from configuration :" + serverString));
        HttpSolrServer server = null;
        try {
            server = new HttpSolrServer(serverString);
            log.info((Object)("Solr server for dataone logging initialized from " + serverString));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            server = null;
        }
        finally {
            this.solr = server;
        }
    }

    public void logEvent(HttpServletRequest request, String identifier, String event, Date dateLogged, String nodeIdentifier) {
        try {
            SolrInputDocument doc1 = new SolrInputDocument();
            String ip = request.getRemoteAddr();
            if (request.getHeader("X-Forwarded-For") != null) {
                for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                    if (request.getHeader("X-Forwarded-For").contains(ip)) continue;
                    ip = xfip.trim();
                }
            }
            doc1.addField("identifier", (Object)(identifier != null ? identifier : "null"));
            doc1.addField("ipAddress", (Object)(ip != null ? ip : "null"));
            doc1.addField("userAgent", (Object)(request.getHeader("User-Agent") != null ? request.getHeader("User-Agent") : "null"));
            doc1.addField("subject", (Object)"public");
            doc1.addField("event", (Object)(event != null ? event : "null"));
            doc1.addField("dateLogged", (Object)dateFormatUTC.format(dateLogged != null ? dateLogged : new Date()));
            doc1.addField("nodeIdentifier", (Object)(nodeIdentifier != null ? nodeIdentifier : "null"));
            this.solr.add(doc1);
            this.solr.commit();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public QueryResponse getLogRecords(Date fromDate, Date toDate, String event, String pidFilter, int start, int count) throws java.text.ParseException, SolrServerException, ParseException {
        SolrQuery solrQuery = new SolrQuery("nodeIdentifier:urn*");
        solrQuery.setSort("dateLogged", SolrQuery.ORDER.asc);
        if (event != null) {
            solrQuery.addFilterQuery(new String[]{"event:" + event});
            log.info((Object)("Adding event Filter: " + event));
        }
        if (fromDate != null && toDate != null) {
            solrQuery.addFilterQuery(new String[]{"dateLogged:[" + dateFormatUTC.format(fromDate) + " TO " + dateFormatUTC.format(toDate) + "]"});
        } else if (fromDate != null) {
            solrQuery.addFilterQuery(new String[]{"dateLogged:[" + dateFormatUTC.format(fromDate) + " TO NOW]"});
        } else if (toDate != null) {
            solrQuery.addFilterQuery(new String[]{"dateLogged:[* TO " + dateFormatUTC.format(toDate) + "]"});
        }
        if (pidFilter != null) {
            String escaped = LUCENE_PATTERN.matcher(pidFilter).replaceAll(REPLACEMENT_STRING);
            solrQuery.addFilterQuery(new String[]{"identifier:" + escaped});
            log.info((Object)("Adding pid filter: " + escaped));
        }
        solrQuery.setStart(Integer.valueOf(start));
        solrQuery.setRows(Integer.valueOf(count));
        return this.solr.query((SolrParams)solrQuery);
    }

    static {
        dateFormatUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

