/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.collection;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.aspect.administrative.FlowCurationUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class CurateCollectionForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = CurateCollectionForm.message("xmlui.general.dspace_home");
    private static final Message T_collection_trail = CurateCollectionForm.message("xmlui.administrative.collection.general.collection_trail");
    private static final Message T_options_metadata = CurateCollectionForm.message("xmlui.administrative.collection.general.options_metadata");
    private static final Message T_options_roles = CurateCollectionForm.message("xmlui.administrative.collection.general.options_roles");
    private static final Message T_options_harvest = CurateCollectionForm.message("xmlui.administrative.collection.GeneralCollectionHarvestingForm.options_harvest");
    private static final Message T_options_curate = CurateCollectionForm.message("xmlui.administrative.collection.general.options_curate");
    private static final Message T_submit_perform = CurateCollectionForm.message("xmlui.general.perform");
    private static final Message T_submit_queue = CurateCollectionForm.message("xmlui.general.queue");
    private static final Message T_submit_return = CurateCollectionForm.message("xmlui.general.return");
    private static final Message T_main_head = CurateCollectionForm.message("xmlui.administrative.collection.CurateCollectionForm.main_head");
    private static final Message T_title = CurateCollectionForm.message("xmlui.administrative.collection.CurateCollectionForm.title");
    private static final Message T_trail = CurateCollectionForm.message("xmlui.administrative.collection.CurateCollectionForm.trail");
    private static final Message T_label_name = CurateCollectionForm.message("xmlui.administrative.collection.CurateCollectionForm.label_name");
    private static final Message T_taskgroup_label_name = CurateCollectionForm.message("xmlui.administrative.CurateForm.taskgroup_label_name");

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        FlowCurationUtils.setupCurationTasks();
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_collection_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException, AuthorizeException, UnsupportedEncodingException {
        int collectionID = this.parameters.getParameterAsInteger("collectionID", -1);
        Collection thisCollection = Collection.find((Context)this.context, (int)collectionID);
        String baseURL = this.contextPath + "/admin/collection?administrative-continue=" + this.knot.getId();
        Division main = body.addInteractiveDivision("collection-curate", this.contextPath + "/admin/collection", "multipart", "primary administrative collection");
        main.setHead(T_main_head.parameterize(thisCollection.getName()));
        List options = main.addList("options", "simple", "horizontal");
        options.addItem().addXref(baseURL + "&submit_metadata", T_options_metadata);
        options.addItem().addXref(baseURL + "&submit_roles", T_options_roles);
        options.addItem().addXref(baseURL + "&submit_harvesting", T_options_harvest);
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_curate", T_options_curate);
        List curationTaskList = main.addList("curationTaskList", "form");
        String curateGroup = "";
        try {
            curateGroup = this.parameters.getParameter("select_curate_group") != null ? this.parameters.getParameter("select_curate_group") : "ungrouped";
        }
        catch (Exception pe) {
            // empty catch block
        }
        if (!FlowCurationUtils.groups.isEmpty()) {
            curationTaskList.addLabel(T_taskgroup_label_name);
            Select groupSelect = curationTaskList.addItem().addSelect("select_curate_group");
            groupSelect = FlowCurationUtils.getGroupSelectOptions(groupSelect);
            groupSelect.setSize(1);
            groupSelect.setRequired();
            groupSelect.setEvtBehavior("submitOnChange");
            if (curateGroup.equals("")) {
                curateGroup = FlowCurationUtils.groups.keySet().iterator().next();
            }
            groupSelect.setOptionSelected(curateGroup);
        }
        curationTaskList.addLabel(T_label_name);
        Select taskSelect = curationTaskList.addItem().addSelect("curate_task");
        taskSelect = FlowCurationUtils.getTaskSelectOptions(taskSelect, curateGroup);
        taskSelect.setSize(1);
        taskSelect.setRequired();
        Para buttonList = main.addPara();
        buttonList.addButton("submit_curate_task").setValue(T_submit_perform);
        buttonList.addButton("submit_queue_task").setValue(T_submit_queue);
        buttonList.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

