/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.collection;

import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.harvest.HarvestedCollection;

public class ToggleCollectionHarvestingForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = ToggleCollectionHarvestingForm.message("xmlui.general.dspace_home");
    private static final Message T_collection_trail = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.general.collection_trail");
    private static final Message T_options_metadata = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.general.options_metadata");
    private static final Message T_options_roles = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.general.options_roles");
    private static final Message T_options_curate = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.general.options_curate");
    private static final Message T_main_head = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.EditCollectionMetadataForm.main_head");
    private static final Message T_options_harvest = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.GeneralCollectionHarvestingForm.options_harvest");
    private static final Message T_title = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.GeneralCollectionHarvestingForm.title");
    private static final Message T_trail = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.GeneralCollectionHarvestingForm.trail");
    private static final Message T_label_source = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.GeneralCollectionHarvestingForm.label_source");
    private static final Message T_source_normal = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.GeneralCollectionHarvestingForm.source_normal");
    private static final Message T_source_harvested = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.GeneralCollectionHarvestingForm.source_harvested");
    private static final Message T_submit_return = ToggleCollectionHarvestingForm.message("xmlui.general.return");
    private static final Message T_submit_save = ToggleCollectionHarvestingForm.message("xmlui.administrative.collection.GeneralCollectionHarvestingForm.submit_save");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_collection_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        int collectionID = this.parameters.getParameterAsInteger("collectionID", -1);
        Collection thisCollection = Collection.find((Context)this.context, (int)collectionID);
        HarvestedCollection hc = HarvestedCollection.find((Context)this.context, (int)collectionID);
        String baseURL = this.contextPath + "/admin/collection?administrative-continue=" + this.knot.getId();
        Division main = body.addInteractiveDivision("collection-harvesting-setup", this.contextPath + "/admin/collection", "multipart", "primary administrative collection");
        main.setHead(T_main_head.parameterize(thisCollection.getMetadata("name")));
        List options = main.addList("options", "simple", "horizontal");
        options.addItem().addXref(baseURL + "&submit_metadata", T_options_metadata);
        options.addItem().addXref(baseURL + "&submit_roles", T_options_roles);
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_harvesting", T_options_harvest);
        options.addItem().addXref(baseURL + "&submit_curate", T_options_curate);
        List harvestSource = main.addList("harvestSource", "form");
        harvestSource.addLabel(T_label_source);
        Radio source = harvestSource.addItem().addRadio("source");
        source.addOption(hc == null, "source_normal", T_source_normal);
        source.addOption(hc != null, "source_harvested", T_source_harvested);
        Para buttonList = main.addPara();
        buttonList.addButton("submit_save").setValue(T_submit_save);
        buttonList.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

