/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.eperson;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

public class ManageEPeopleMain
extends AbstractDSpaceTransformer {
    private static final Message T_title = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.title");
    private static final Message T_eperson_trail = ManageEPeopleMain.message("xmlui.administrative.eperson.general.epeople_trail");
    private static final Message T_main_head = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.main_head");
    private static final Message T_actions_head = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.actions_head");
    private static final Message T_actions_create = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.actions_create");
    private static final Message T_actions_create_link = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.actions_create_link");
    private static final Message T_actions_browse = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.actions_browse");
    private static final Message T_actions_browse_link = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.actions_browse_link");
    private static final Message T_actions_search = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.actions_search");
    private static final Message T_search_help = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.search_help");
    private static final Message T_dspace_home = ManageEPeopleMain.message("xmlui.general.dspace_home");
    private static final Message T_go = ManageEPeopleMain.message("xmlui.general.go");
    private static final Message T_search_head = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.search_head");
    private static final Message T_search_column1 = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.search_column1");
    private static final Message T_search_column2 = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.search_column2");
    private static final Message T_search_column3 = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.search_column3");
    private static final Message T_search_column4 = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.search_column4");
    private static final Message T_submit_delete = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.submit_delete");
    private static final Message T_no_results = ManageEPeopleMain.message("xmlui.administrative.eperson.ManageEPeopleMain.no_results");
    private static final int PAGE_SIZE = 15;

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(null, T_eperson_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException {
        int page = this.parameters.getParameterAsInteger("page", 0);
        int highlightID = this.parameters.getParameterAsInteger("highlightID", -1);
        String query = ManageEPeopleMain.decodeFromURL(this.parameters.getParameter("query", null));
        String baseURL = this.contextPath + "/admin/epeople?administrative-continue=" + this.knot.getId();
        int resultCount = EPerson.searchResultCount((Context)this.context, (String)query);
        EPerson[] epeople = EPerson.search((Context)this.context, (String)query, (int)(page * 15), (int)15);
        Division main = body.addInteractiveDivision("epeople-main", this.contextPath + "/admin/epeople", "post", "primary administrative eperson");
        main.setHead(T_main_head);
        Division actions = main.addDivision("epeople-actions");
        actions.setHead(T_actions_head);
        org.dspace.app.xmlui.wing.element.List actionsList = actions.addList("actions");
        actionsList.addLabel(T_actions_create);
        actionsList.addItemXref(baseURL + "&submit_add", T_actions_create_link);
        actionsList.addLabel(T_actions_browse);
        actionsList.addItemXref(baseURL + "&query&submit_search", T_actions_browse_link);
        actionsList.addLabel(T_actions_search);
        Item actionItem = actionsList.addItem();
        Text queryField = actionItem.addText("query");
        queryField.setAutofocus("autofocus");
        if (query != null) {
            queryField.setValue(query);
        }
        queryField.setHelp(T_search_help);
        actionItem.addButton("submit_search").setValue(T_go);
        Division search = main.addDivision("eperson-search");
        search.setHead(T_search_head);
        if (resultCount > 15) {
            int firstIndex = page * 15 + 1;
            int lastIndex = page * 15 + epeople.length;
            String nextURL = null;
            String prevURL = null;
            if (page < resultCount / 15) {
                nextURL = baseURL + "&page=" + (page + 1);
            }
            if (page > 0) {
                prevURL = baseURL + "&page=" + (page - 1);
            }
            search.setSimplePagination(resultCount, firstIndex, lastIndex, prevURL, nextURL);
        }
        Table table = search.addTable("eperson-search-table", epeople.length + 1, 1);
        Row header = table.addRow("header");
        header.addCell().addContent(T_search_column1);
        header.addCell().addContent(T_search_column2);
        header.addCell().addContent(T_search_column3);
        header.addCell().addContent(T_search_column4);
        for (EPerson person : epeople) {
            String epersonID = String.valueOf(person.getID());
            String fullName = person.getFullName();
            String email = person.getEmail();
            String url = baseURL + "&submit_edit&epersonID=" + epersonID;
            List deleteConstraints = person.getDeleteConstraints();
            Row row = person.getID() == highlightID ? table.addRow(null, null, "highlight") : table.addRow();
            CheckBox selectEPerson = row.addCell().addCheckBox("select_eperson");
            selectEPerson.setLabel(epersonID);
            selectEPerson.addOption(epersonID);
            if (deleteConstraints != null && deleteConstraints.size() > 0) {
                selectEPerson.setDisabled();
            }
            row.addCellContent(epersonID);
            row.addCell().addXref(url, fullName);
            row.addCell().addXref(url, email);
        }
        if (epeople.length <= 0) {
            Cell cell = table.addRow().addCell(1, 4);
            cell.addHighlight("italic").addContent(T_no_results);
        } else {
            search.addPara().addButton("submit_delete").setValue(T_submit_delete);
        }
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

