/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.storage.bitstore.BitstreamStorageManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class ItemRequestResponseAction
extends AbstractAction {
    private static Logger log = Logger.getLogger(ItemRequestResponseAction.class);

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String token = parameters.getParameter("token", "");
        String decision = request.getParameter("decision");
        String isSent = request.getParameter("isSent");
        String message = request.getParameter("message");
        Context context = ContextUtil.obtainContext(objectModel);
        request.setAttribute("token", (Object)token);
        TableRow requestItem = DatabaseManager.findByUnique((Context)context, (String)"requestitem", (String)"token", (Object)token);
        Item item = Item.find((Context)context, (int)requestItem.getIntColumn("item_id"));
        DCValue[] titleDC = item.getDC("title", null, "*");
        String title = titleDC != null || titleDC.length > 0 ? titleDC[0].value : "untitled";
        String button = "";
        if (request.getParameter("send") != null) {
            decision = "true";
            button = "send";
        } else if (request.getParameter("dontSend") != null) {
            decision = "false";
            button = "dontSend";
        }
        if (request.getParameter("mail") != null) {
            button = "mail";
        } else if (request.getParameter("back") != null) {
            button = "back";
        }
        if (request.getParameter("openAccess") != null) {
            button = "openAccess";
        }
        if (button.equals("mail") && StringUtils.isNotEmpty((String)decision) && decision.equals("true")) {
            this.processSendDocuments(context, request, requestItem, item, title);
            isSent = "true";
        } else if (button.equals("mail") && StringUtils.isNotEmpty((String)decision) && decision.equals("false")) {
            this.processDeny(context, request, requestItem, item, title);
            isSent = "true";
        } else if (button.equals("openAccess")) {
            if (this.processOpenAccessRequest(context, request, requestItem, item, title)) {
                return null;
            }
        } else if (button.equals("back")) {
            decision = null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("decision", decision);
        map.put("token", token);
        map.put("isSent", isSent);
        map.put("title", title);
        map.put("name", request.getParameter("name"));
        map.put("email", request.getParameter("email"));
        return map;
    }

    private boolean processOpenAccessRequest(Context context, Request request, TableRow requestItem, Item item, String title) throws SQLException, IOException, MessagingException {
        String name = request.getParameter("name");
        String mail = request.getParameter("email");
        if (StringUtils.isNotEmpty((String)name) && StringUtils.isNotEmpty((String)mail)) {
            EPerson submiter = item.getSubmitter();
            String emailRequest = submiter != null ? submiter.getEmail() : ConfigurationManager.getProperty((String)"mail.helpdesk");
            if (emailRequest == null) {
                emailRequest = ConfigurationManager.getProperty((String)"mail.admin");
            }
            Email email = Email.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"request_item.admin"));
            email.addRecipient(emailRequest);
            email.addArgument((Object)Bitstream.find((Context)context, (int)requestItem.getIntColumn("bitstream_id")).getName());
            email.addArgument((Object)HandleManager.getCanonicalForm((String)item.getHandle()));
            email.addArgument((Object)requestItem.getStringColumn("token"));
            email.addArgument((Object)name);
            email.addArgument((Object)mail);
            email.send();
            return true;
        }
        return false;
    }

    private void processSendDocuments(Context context, Request request, TableRow requestItem, Item item, String title) throws SQLException, MessagingException, IOException {
        String message = request.getParameter("message");
        String subject = request.getParameter("subject");
        Email email = new Email();
        email.setSubject(subject);
        email.setContent("{0}");
        email.addRecipient(requestItem.getStringColumn("request_email"));
        email.addArgument((Object)message);
        if (requestItem.getBooleanColumn("allfiles")) {
            Bundle[] bundles = item.getBundles("ORIGINAL");
            for (int i = 0; i < bundles.length; ++i) {
                Bitstream[] bitstreams = bundles[i].getBitstreams();
                for (int k = 0; k < bitstreams.length; ++k) {
                    if (bitstreams[k].getFormat().isInternal()) continue;
                    email.addAttachment(BitstreamStorageManager.retrieve((Context)context, (int)bitstreams[k].getID()), bitstreams[k].getName(), bitstreams[k].getFormat().getMIMEType());
                }
            }
        } else {
            Bitstream bit = Bitstream.find((Context)context, (int)requestItem.getIntColumn("bitstream_id"));
            email.addAttachment(BitstreamStorageManager.retrieve((Context)context, (int)requestItem.getIntColumn("bitstream_id")), bit.getName(), bit.getFormat().getMIMEType());
        }
        email.send();
        requestItem.setColumn("decision_date", new Date());
        requestItem.setColumn("accept_request", true);
        DatabaseManager.update((Context)context, (TableRow)requestItem);
    }

    private void processDeny(Context context, Request request, TableRow requestItem, Item item, String title) throws SQLException, IOException, MessagingException {
        String message = request.getParameter("message");
        String subject = request.getParameter("subject");
        Email email = new Email();
        email.setSubject(subject);
        email.setContent("{0}");
        email.addRecipient(requestItem.getStringColumn("request_email"));
        email.addArgument((Object)message);
        email.send();
        requestItem.setColumn("decision_date", new Date());
        requestItem.setColumn("accept_request", false);
        DatabaseManager.update((Context)context, (TableRow)requestItem);
    }
}

