/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.browseArtifacts;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_head_all_of_dspace = Navigation.message("xmlui.ArtifactBrowser.Navigation.head_all_of_dspace");
    private static final Message T_head_browse = Navigation.message("xmlui.ArtifactBrowser.Navigation.head_browse");
    private static final Message T_communities_and_collections = Navigation.message("xmlui.ArtifactBrowser.Navigation.communities_and_collections");
    private static final Message T_head_this_collection = Navigation.message("xmlui.ArtifactBrowser.Navigation.head_this_collection");
    private static final Message T_head_this_community = Navigation.message("xmlui.ArtifactBrowser.Navigation.head_this_community");

    public Serializable getKey() {
        try {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            String key = request.getScheme() + request.getServerName() + request.getServerPort() + request.getSitemapURI() + request.getQueryString();
            DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
            if (dso != null) {
                key = key + "-" + dso.getHandle();
            }
            return Long.valueOf(HashUtil.hash((String)key));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    @Override
    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        List browse = options.addList("browse");
        options.addList("account");
        options.addList("context");
        options.addList("administrative");
        browse.setHead(T_head_browse);
        List browseGlobal = browse.addList("global");
        List browseContext = browse.addList("context");
        browseGlobal.setHead(T_head_all_of_dspace);
        browseGlobal.addItemXref(this.contextPath + "/community-list", T_communities_and_collections);
        this.addBrowseOptions(browseGlobal, this.contextPath + "/browse");
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (dso != null) {
            if (dso instanceof Item) {
                dso = ((Item)dso).getOwningCollection();
            }
            if (dso instanceof Collection) {
                browseContext.setHead(T_head_this_collection);
            }
            if (dso instanceof Community) {
                browseContext.setHead(T_head_this_community);
            }
            String handle = dso.getHandle();
            this.addBrowseOptions(browseContext, this.contextPath + "/handle/" + handle + "/browse");
        }
    }

    private void addBrowseOptions(List browseList, String browseURL) throws WingException {
        try {
            BrowseIndex[] bis;
            for (BrowseIndex bix : bis = BrowseIndex.getBrowseIndices()) {
                HashMap<String, String> queryParams = new HashMap<String, String>();
                queryParams.put("type", bix.getName());
                browseList.addItemXref(AbstractDSpaceTransformer.generateURL(browseURL, queryParams), Navigation.message("xmlui.ArtifactBrowser.Navigation.browse_" + bix.getName()));
            }
        }
        catch (BrowseException bex) {
            throw new UIException("Unable to get browse indicies", bex);
        }
    }
}

