/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.xml.sax.SAXException;

public class CommunitySearch
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(CommunitySearch.class);
    private static final Message T_full_text_search = CommunitySearch.message("xmlui.ArtifactBrowser.CommunityViewer.full_text_search");
    private static final Message T_go = CommunitySearch.message("xmlui.general.go");
    public static final Message T_untitled = CommunitySearch.message("xmlui.general.untitled");
    private static final Message T_head_sub_collections = CommunitySearch.message("xmlui.ArtifactBrowser.CommunityViewer.head_sub_collections");
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            Community community = null;
            try {
                DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
                if (dso == null) {
                    return null;
                }
                if (!(dso instanceof Community)) {
                    return null;
                }
                community = (Community)dso;
                DSpaceValidity validity = new DSpaceValidity();
                validity.add((DSpaceObject)community);
                Community[] subCommunities = community.getSubcommunities();
                Collection[] collections = community.getCollections();
                for (Community community2 : subCommunities) {
                    validity.add((DSpaceObject)community2);
                }
                for (Community community3 : collections) {
                    validity.add((DSpaceObject)community3);
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"view_community", (String)("community_id=" + (community == null ? "" : Integer.valueOf(community.getID())))));
        }
        return this.validity;
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (!(dso instanceof Community)) {
            return;
        }
        Community community = (Community)dso;
        Division home = body.addDivision("community-home", "primary repository community");
        String name = community.getMetadata("name");
        if (name == null || name.length() == 0) {
            home.setHead(T_untitled);
        } else {
            home.setHead(name);
        }
        Division search = home.addDivision("community-search-browse", "secondary search-browse");
        Division query = search.addInteractiveDivision("community-search", this.contextPath + "/handle/" + community.getHandle() + "/discover", "post", "secondary search");
        Para para = query.addPara("search-query", null);
        para.addContent(T_full_text_search);
        para.addContent(" ");
        para.addText("query");
        para.addContent(" ");
        para.addButton("submit").setValue(T_go);
    }

    @Override
    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

