/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.eperson;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.sitemap.PatternException;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

public class LDAPAuthenticateAction
extends AbstractAction {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String username = request.getParameter("username");
        String password = request.getParameter("ldap_password");
        String realm = request.getParameter("login_realm");
        if (username == null || password == null) {
            return null;
        }
        try {
            Context context = AuthenticationUtil.authenticate(objectModel, username, password, realm);
            EPerson eperson = context.getCurrentUser();
            if (eperson != null) {
                String redirectURL = request.getContextPath();
                if (AuthenticationUtil.isInterupptedRequest(objectModel)) {
                    redirectURL = redirectURL + AuthenticationUtil.resumeInterruptedRequest(objectModel);
                } else {
                    String loginRedirect = ConfigurationManager.getProperty((String)"xmlui.user.loginredirect");
                    redirectURL = redirectURL + (loginRedirect != null ? loginRedirect.trim() : "/");
                }
                HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                httpResponse.sendRedirect(redirectURL);
                context.setCurrentUser(null);
                return new HashMap();
            }
        }
        catch (SQLException sqle) {
            throw new PatternException("Unable to perform authentication", (Throwable)sqle);
        }
        return null;
    }
}

