/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.eperson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.aspect.eperson.EPersonUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Text;
import org.xml.sax.SAXException;

public class StartForgotPassword
extends AbstractDSpaceTransformer {
    private static final Message T_title = StartForgotPassword.message("xmlui.EPerson.StartForgotPassword.title");
    private static final Message T_dspace_home = StartForgotPassword.message("xmlui.general.dspace_home");
    private static final Message T_trail_forgot_password = StartForgotPassword.message("xmlui.EPerson.trail_forgot_password");
    private static final Message T_head = StartForgotPassword.message("xmlui.EPerson.StartForgotPassword.head");
    private static final Message T_para1 = StartForgotPassword.message("xmlui.EPerson.StartForgotPassword.para1");
    private static final Message T_email_address = StartForgotPassword.message("xmlui.EPerson.StartForgotPassword.email_address");
    private static final Message T_email_address_help = StartForgotPassword.message("xmlui.EPerson.StartForgotPassword.email_address_help");
    private static final Message T_error_not_found = StartForgotPassword.message("xmlui.EPerson.StartForgotPassword.error_not_found");
    private static final Message T_submit = StartForgotPassword.message("xmlui.EPerson.StartForgotPassword.submit");
    private String email;
    private List<String> errors;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.email = parameters.getParameter("email", "");
        String errors = parameters.getParameter("errors", "");
        this.errors = errors.length() > 0 ? Arrays.asList(errors.split(",")) : new ArrayList<String>();
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail_forgot_password);
    }

    @Override
    public void addBody(Body body) throws WingException {
        Division forgot = body.addInteractiveDivision("start-forgot-password", this.contextPath + "/forgot", "post", "primary");
        forgot.setHead(T_head);
        EPersonUtils.forgottProgressList(forgot, 1);
        forgot.addPara(T_para1);
        org.dspace.app.xmlui.wing.element.List form = forgot.addList("form", "form");
        Text email = form.addItem().addText("email");
        email.setRequired();
        email.setAutofocus("autofocus");
        email.setLabel(T_email_address);
        email.setHelp(T_email_address_help);
        if (email != null) {
            email.setValue(this.email);
        }
        if (this.errors.contains("email")) {
            email.addError(T_error_not_found);
        }
        Item submit = form.addItem();
        submit.addButton("submit").setValue(T_submit);
        forgot.addHidden("eperson-continue").setValue(this.knot.getId());
    }

    @Override
    public void recycle() {
        this.email = null;
        super.recycle();
    }
}

