/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.eperson;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.aspect.eperson.EPersonUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.xml.sax.SAXException;

public class VerifyEmail
extends AbstractDSpaceTransformer {
    private static final Message T_title = VerifyEmail.message("xmlui.EPerson.VerifyEmail.title");
    private static final Message T_dspace_home = VerifyEmail.message("xmlui.general.dspace_home");
    private static final Message T_trail_forgot_password = VerifyEmail.message("xmlui.EPerson.trail_forgot_password");
    private static final Message T_trail_new_registration = VerifyEmail.message("xmlui.EPerson.trail_new_registration");
    private static final Message T_head = VerifyEmail.message("xmlui.EPerson.VerifyEmail.head");
    private static final Message T_para = VerifyEmail.message("xmlui.EPerson.VerifyEmail.para");
    private String email;
    private boolean forgot;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        try {
            this.email = parameters.getParameter("email");
            this.forgot = parameters.getParameterAsBoolean("forgot");
        }
        catch (ParameterException pe) {
            throw new ProcessingException((Exception)((Object)pe));
        }
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        if (this.forgot) {
            pageMeta.addTrail().addContent(T_trail_forgot_password);
        } else {
            pageMeta.addTrail().addContent(T_trail_new_registration);
        }
    }

    @Override
    public void addBody(Body body) throws WingException {
        Division verify = body.addDivision("verify-email", "primary");
        verify.setHead(T_head);
        if (this.forgot) {
            EPersonUtils.forgottProgressList(verify, 1);
        } else {
            EPersonUtils.registrationProgressList(verify, 1);
        }
        verify.addPara(T_para.parameterize(this.email));
    }

    @Override
    public void recycle() {
        this.email = null;
        super.recycle();
    }
}

