/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.statistics;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.statistics.AbstractStatisticsDataTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.statistics.content.DatasetGenerator;
import org.dspace.statistics.content.DatasetSearchGenerator;
import org.dspace.statistics.content.StatisticsData;
import org.dspace.statistics.content.StatisticsDataSearches;
import org.dspace.statistics.content.StatisticsTable;
import org.dspace.statistics.content.filter.StatisticsFilter;
import org.dspace.statistics.content.filter.StatisticsSolrDateFilter;
import org.xml.sax.SAXException;

public class StatisticsSearchTransformer
extends AbstractStatisticsDataTransformer {
    private static final Message T_dspace_home = StatisticsSearchTransformer.message("xmlui.general.dspace_home");
    private static final Message T_search_terms_head = StatisticsSearchTransformer.message("xmlui.statistics.StatisticsSearchTransformer.search-terms.head");
    private static final Message T_search_total_head = StatisticsSearchTransformer.message("xmlui.statistics.StatisticsSearchTransformer.search-total.head");
    private static final Message T_trail = StatisticsSearchTransformer.message("xmlui.statistics.trail-search");
    private static final Message T_head_title = StatisticsSearchTransformer.message("xmlui.statistics.search.title");
    private static final Message T_retrieval_error = StatisticsSearchTransformer.message("xmlui.statistics.search.error");
    private static final Message T_search_head = StatisticsSearchTransformer.message("xmlui.statistics.search.head");
    private static final Message T_search_head_dso = StatisticsSearchTransformer.message("xmlui.statistics.search.head-dso");
    private static final Message T_no_results = StatisticsSearchTransformer.message("xmlui.statistics.search.no-results");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        if (dso != null) {
            HandleUtil.buildHandleTrail(dso, pageMeta, this.contextPath);
        }
        pageMeta.addTrailLink(this.contextPath + (dso != null && dso.getHandle() != null ? "/handle/" + dso.getHandle() : "") + "/search-statistics", T_trail);
        pageMeta.addMetadata("title").addContent(T_head_title);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException, ProcessingException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String selectedTimeFilter = request.getParameter("time_filter");
        StringBuilder actionPath = new StringBuilder().append(request.getContextPath());
        if (dso != null) {
            actionPath.append("/handle/").append(dso.getHandle());
        }
        actionPath.append("/search-statistics");
        Division mainDivision = body.addInteractiveDivision("search-statistics", actionPath.toString(), "post", null);
        if (dso != null) {
            mainDivision.setHead(T_search_head_dso.parameterize(dso.getName()));
        } else {
            mainDivision.setHead(T_search_head);
        }
        try {
            Division searchTermsDivision = mainDivision.addDivision("search-terms");
            searchTermsDivision.setHead(T_search_terms_head);
            this.addTimeFilter(searchTermsDivision);
            StatisticsSolrDateFilter dateFilter = this.getDateFilter(selectedTimeFilter);
            StatisticsTable statisticsTable = new StatisticsTable((StatisticsData)new StatisticsDataSearches(dso));
            DatasetSearchGenerator queryGenerator = new DatasetSearchGenerator();
            queryGenerator.setType("query");
            queryGenerator.setMax(10);
            queryGenerator.setMode(DatasetSearchGenerator.Mode.SEARCH_OVERVIEW);
            queryGenerator.setPercentage(true);
            queryGenerator.setRetrievePageViews(true);
            statisticsTable.addDatasetGenerator((DatasetGenerator)queryGenerator);
            if (dateFilter != null) {
                statisticsTable.addFilter((StatisticsFilter)dateFilter);
            }
            this.addDisplayTable(searchTermsDivision, statisticsTable, true, null);
            Division totalDivision = mainDivision.addDivision("search-total");
            totalDivision.setHead(T_search_total_head);
            statisticsTable = new StatisticsTable((StatisticsData)new StatisticsDataSearches(dso));
            queryGenerator = new DatasetSearchGenerator();
            queryGenerator.setMode(DatasetSearchGenerator.Mode.SEARCH_OVERVIEW_TOTAL);
            queryGenerator.setPercentage(true);
            queryGenerator.setRetrievePageViews(true);
            statisticsTable.addDatasetGenerator((DatasetGenerator)queryGenerator);
            if (dateFilter != null) {
                statisticsTable.addFilter((StatisticsFilter)dateFilter);
            }
            this.addDisplayTable(totalDivision, statisticsTable, false, null);
        }
        catch (Exception e) {
            mainDivision.addPara().addContent(T_retrieval_error);
        }
    }

    @Override
    protected Message getNoResultsMessage() {
        return T_no_results;
    }
}

