/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.swordclient;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.authorize.AuthorizeException;
import org.dspace.sword.client.ServiceDocumentHelper;
import org.purl.sword.base.Collection;
import org.purl.sword.base.ServiceDocument;
import org.xml.sax.SAXException;

public class SelectCollectionTransformer
extends AbstractDSpaceTransformer {
    private static Logger log = Logger.getLogger(SelectCollectionTransformer.class);
    private static final Message T_dspace_home = SelectCollectionTransformer.message("xmlui.general.dspace_home");
    private static final Message T_title = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.title");
    private static final Message T_SwordCopy_trail = SelectCollectionTransformer.message("xmlui.swordclient.general.SwordCopy_trail");
    private static final Message T_trail = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.trail");
    private static final Message T_main_head = SelectCollectionTransformer.message("xmlui.swordclient.general.main_head");
    private static final Message T_collection_head = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.collection_head");
    private static final Message T_collection_title = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.collection_title");
    private static final Message T_collection_policy = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.collection policy");
    private static final Message T_collection_mediation = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.collection_mediation");
    private static final Message T_collection_file_types = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.collection_file_types");
    private static final Message T_collection_package_formats = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.collection_package_formats");
    private static final Message T_collection_deposit_button = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.collection_deposit_button");
    private static final Message T_sub_service_target = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.sub_service_target");
    private static final Message T_sub_service_target_button = SelectCollectionTransformer.message("xmlui.swordclient.SelectCollection.sub_service_target_button");
    private static final Message T_submit_cancel = SelectCollectionTransformer.message("xmlui.general.cancel");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_SwordCopy_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String handle = this.parameters.getParameter("handle", null);
        Division main = body.addDivision("main");
        main.setHead(T_main_head.parameterize(handle));
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ServiceDocument serviceDoc = (ServiceDocument)request.getAttribute("serviceDoc");
        List<Collection> collections = ServiceDocumentHelper.getCollections(serviceDoc);
        for (Collection collection : collections) {
            Division collectionDiv = main.addInteractiveDivision("collection", this.contextPath + "/swordclient", "post", "");
            collectionDiv.setHead(T_collection_head.parameterize(collection.getLocation()));
            org.dspace.app.xmlui.wing.element.List paramsList = collectionDiv.addList(collection + "Params", "bulleted");
            paramsList.addItem().addContent(T_collection_title.parameterize(collection.getTitle()));
            paramsList.addItem().addContent(T_collection_policy.parameterize(collection.getCollectionPolicy()));
            paramsList.addItem().addContent(T_collection_mediation.parameterize(Boolean.toString(collection.getMediation())));
            String[] fileTypes = collection.getAccepts();
            String fileTypesString = this.arrayToString(fileTypes);
            paramsList.addItem().addContent(T_collection_file_types.parameterize(fileTypesString));
            String[] packageFormats = ServiceDocumentHelper.getPackageFormats(collection);
            String packageFormatsString = this.arrayToString(packageFormats);
            paramsList.addItem().addContent(T_collection_package_formats.parameterize(packageFormatsString));
            if (fileTypes.length > 0 && packageFormats.length > 0) {
                collectionDiv.addPara().addButton("deposit").setValue(T_collection_deposit_button);
                collectionDiv.addHidden("location").setValue(collection.getLocation());
                collectionDiv.addHidden("swordclient-continue").setValue(this.knot.getId());
            }
            if (collection.getService() == null || collection.getService().length() <= 0) continue;
            collectionDiv.addPara(T_sub_service_target + collection.getService());
            collectionDiv.addPara().addButton("sub-service").setValue(T_sub_service_target_button);
            collectionDiv.addHidden("sub-service").setValue(collection.getService());
            collectionDiv.addHidden("swordclient-continue").setValue(this.knot.getId());
        }
        Division buttons = main.addInteractiveDivision("buttons", this.contextPath + "/swordclient", "post", "");
        Para buttonList = buttons.addPara();
        buttonList.addButton("submit_cancel").setValue(T_submit_cancel);
        buttons.addHidden("swordclient-continue").setValue(this.knot.getId());
    }

    private String arrayToString(String[] strings) {
        if (strings.length == 0) {
            return "none";
        }
        StringBuffer text = new StringBuffer("");
        for (String string : strings) {
            text.append(string).append(", ");
        }
        text.delete(text.length() - 2, text.length() - 1);
        return text.toString();
    }
}

