/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.swordclient;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Password;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class SelectTargetTransformer
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = SelectTargetTransformer.message("xmlui.general.dspace_home");
    private static final Message T_title = SelectTargetTransformer.message("xmlui.swordclient.SelectTarget.title");
    private static final Message T_SwordCopy_trail = SelectTargetTransformer.message("xmlui.swordclient.general.SwordCopy_trail");
    private static final Message T_trail = SelectTargetTransformer.message("xmlui.swordclient.SelectTarget.trail");
    private static final Message T_main_head = SelectTargetTransformer.message("xmlui.swordclient.general.main_head");
    private static final Message T_submit_next = SelectTargetTransformer.message("xmlui.general.next");
    private static final Message T_submit_cancel = SelectTargetTransformer.message("xmlui.general.cancel");
    private static final Message T_url = SelectTargetTransformer.message("xmlui.swordclient.SelectTarget.url");
    private static final Message T_other_url = SelectTargetTransformer.message("xmlui.swordclient.SelectTarget.other_url");
    private static final Message T_username = SelectTargetTransformer.message("xmlui.swordclient.SelectTarget.username");
    private static final Message T_password = SelectTargetTransformer.message("xmlui.swordclient.SelectTarget.password");
    private static final Message T_on_behalf_of = SelectTargetTransformer.message("xmlui.swordclient.SelectTarget.on_behalf_of");
    private static final Message T_url_error = SelectTargetTransformer.message("xmlui.swordclient.SelectTargetAction.url_error");
    private static final Message T_username_error = SelectTargetTransformer.message("xmlui.swordclient.SelectTargetAction.username_error");
    private static final Message T_password_error = SelectTargetTransformer.message("xmlui.swordclient.SelectTargetAction.password_error");
    private static Logger log = Logger.getLogger(SelectTargetTransformer.class);

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_SwordCopy_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        String[] targets;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String handle = this.parameters.getParameter("handle", null);
        String errorString = this.parameters.getParameter("errors", null);
        ArrayList<String> errors = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)errorString)) {
            for (String error : errorString.split(",")) {
                errors.add(error);
            }
        }
        String urlValue = request.getParameter("url");
        String otherUrlValue = request.getParameter("otherUrl");
        String usernameValue = request.getParameter("username");
        String passwordValue = request.getParameter("password");
        Division main = body.addInteractiveDivision("service-document", this.contextPath + "/swordclient", "post", "");
        main.setHead(T_main_head.parameterize(handle));
        List targetDetails = main.addList("target_details", "form");
        Select source = targetDetails.addItem().addSelect("url");
        String targetsString = ConfigurationManager.getProperty((String)"sword-client", (String)"targets");
        for (String target : targets = targetsString.split(",")) {
            if (urlValue != null && urlValue.length() > 0 && urlValue.equals(target)) {
                source.addOption(false, target, target);
                continue;
            }
            source.addOption(false, target, target);
        }
        source.setLabel(T_url);
        Text otherUrl = targetDetails.addItem().addText("otherUrl");
        otherUrl.setLabel(T_other_url);
        otherUrl.setValue(otherUrlValue);
        if (errors.contains("otherUrl")) {
            otherUrl.addError(T_url_error);
        }
        Text username = targetDetails.addItem().addText("username");
        username.setRequired();
        username.setLabel(T_username);
        username.setValue(usernameValue);
        if (errors.contains("username")) {
            username.addError(T_username_error);
        }
        Password password = targetDetails.addItem().addPassword("password");
        password.setRequired();
        password.setLabel(T_password);
        if (errors.contains("password")) {
            password.addError(T_password_error);
        }
        Text onBehalfOf = targetDetails.addItem().addText("onBehalfOf");
        onBehalfOf.setLabel(T_on_behalf_of);
        Para buttonList = main.addPara();
        buttonList.addButton("submit_next").setValue(T_submit_next);
        buttonList.addButton("submit_cancel").setValue(T_submit_cancel);
        main.addHidden("swordclient-continue").setValue(this.knot.getId());
    }
}

