/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.eperson.EPerson;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;

public class DeleteVersionsConfirm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = DeleteVersionsConfirm.message("xmlui.general.dspace_home");
    private static final Message T_title = DeleteVersionsConfirm.message("xmlui.aspect.versioning.DeleteVersionsConfirm.title");
    private static final Message T_trail = DeleteVersionsConfirm.message("xmlui.aspect.versioning.DeleteVersionsConfirm.trail");
    private static final Message T_head1 = DeleteVersionsConfirm.message("xmlui.aspect.versioning.DeleteVersionsConfirm.head1");
    private static final Message T_para1 = DeleteVersionsConfirm.message("xmlui.aspect.versioning.DeleteVersionsConfirm.para1");
    private static final Message T_para2 = DeleteVersionsConfirm.message("xmlui.aspect.versioning.DeleteVersionsConfirm.para2");
    private static final Message T_column1 = DeleteVersionsConfirm.message("xmlui.aspect.versioning.DeleteVersionsConfirm.column1");
    private static final Message T_column2 = DeleteVersionsConfirm.message("xmlui.aspect.versioning.DeleteVersionsConfirm.column2");
    private static final Message T_column3 = DeleteVersionsConfirm.message("xmlui.aspect.versioning.DeleteVersionsConfirm.column3");
    private static final Message T_column4 = DeleteVersionsConfirm.message("xmlui.aspect.versioning.DeleteVersionsConfirm.column4");
    private static final Message T_column5 = DeleteVersionsConfirm.message("xmlui.aspect.versioning.DeleteVersionsConfirm.column5");
    private static final Message T_submit_delete = DeleteVersionsConfirm.message("xmlui.general.delete");
    private static final Message T_submit_cancel = DeleteVersionsConfirm.message("xmlui.general.cancel");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, AuthorizeException {
        Division main = this.createMainDivision(body);
        this.createTable(main);
        this.addButtons(main);
        main.addHidden("versioning-continue").setValue(this.knot.getId());
    }

    private Division createMainDivision(Body body) throws WingException {
        Division main = body.addInteractiveDivision("versions-confirm-delete", this.contextPath + "/item/versionhistory", "post", "delete version");
        main.setHead(T_head1);
        Para helpPara = main.addPara();
        helpPara.addContent(T_para1);
        helpPara.addHighlight("bold").addContent(T_para2);
        return main;
    }

    private void createTable(Division main) throws WingException {
        String idsString = this.parameters.getParameter("versionIDs", null);
        Table table = main.addTable("versions-confirm-delete", 1, 1);
        Row header = table.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        header.addCellContent(T_column4);
        header.addCellContent(T_column5);
        for (String id : idsString.split(",")) {
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            Version version = null;
            if (StringUtils.isNotBlank((String)id)) {
                version = versioningService.getVersion(this.context, Integer.parseInt(id));
            }
            if (version == null) continue;
            Row row = table.addRow();
            row.addCell().addContent(version.getVersionNumber());
            this.addItemIdentifier(row.addCell(), version);
            EPerson editor = version.getEperson();
            row.addCell().addXref("mailto:" + editor.getEmail(), editor.getFullName());
            row.addCell().addContent(new DCDate(version.getVersionDate()).toString());
            row.addCell().addContent(version.getSummary());
        }
    }

    private void addButtons(Division main) throws WingException {
        Para buttons = main.addPara();
        buttons.addButton("submit_confirm").setValue(T_submit_delete);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
    }

    private void addItemIdentifier(Cell cell, Version version) throws WingException {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        VersionHistory versionHistory = versioningService.findVersionByHistoryId(this.context, version.getVersionHistoryID());
        Item item = versionHistory.getLatestVersion().getItem();
        String itemHandle = item.getHandle();
        DCValue[] identifiers = item.getMetadata("dc", "identifier", null, "*");
        String itemIdentifier = null;
        if (identifiers != null && identifiers.length > 0) {
            itemIdentifier = identifiers[0].value;
        }
        if (itemIdentifier != null) {
            cell.addXref(this.contextPath + "/resource/" + itemIdentifier, itemIdentifier);
        } else {
            cell.addXref(this.contextPath + "/handle/" + itemHandle, itemHandle);
        }
    }
}

