/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.sql.SQLException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;

public class VersionItemForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = VersionItemForm.message("xmlui.general.dspace_home");
    private static final Message T_submit_cancel = VersionItemForm.message("xmlui.general.cancel");
    private static final Message T_title = VersionItemForm.message("xmlui.aspect.versioning.VersionItemForm.title");
    private static final Message T_trail = VersionItemForm.message("xmlui.aspect.versioning.VersionItemForm.trail");
    private static final Message T_head1 = VersionItemForm.message("xmlui.aspect.versioning.VersionItemForm.head1");
    private static final Message T_submit_version = VersionItemForm.message("xmlui.aspect.versioning.VersionItemForm.submit_version");
    private static final Message T_submit_update_version = VersionItemForm.message("xmlui.aspect.versioning.VersionItemForm.submit_update_version");
    private static final Message T_summary = VersionItemForm.message("xmlui.aspect.versioning.VersionItemForm.summary");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException, SQLException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        Item item = this.getItem();
        if (item != null) {
            HandleUtil.buildHandleTrail((DSpaceObject)item, pageMeta, this.contextPath);
            pageMeta.addTrailLink(this.contextPath + "/handle/" + item.getHandle(), item.getName());
        }
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        String summary;
        Item item = this.getItem();
        boolean canVersion = false;
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        canVersion = versioningService.canVersion(this.context, item);
        if (!canVersion && !AuthorizeManager.isAdmin((Context)this.context, (DSpaceObject)item.getOwningCollection())) {
            throw new AuthorizeException();
        }
        try {
            summary = this.parameters.getParameter("summary");
        }
        catch (ParameterException e) {
            throw new RuntimeException(e);
        }
        Division main = body.addInteractiveDivision("version-item", this.contextPath + "/item/version", "post", "primary administrative version");
        main.setHead(T_head1.parameterize(item.getHandle()));
        List fields = main.addList("fields", "form");
        Composite addComposite = fields.addItem().addComposite("summary");
        addComposite.setLabel(T_summary);
        TextArea addValue = addComposite.addTextArea("summary");
        if (summary != null) {
            addValue.setValue(summary);
        }
        Para actions = main.addPara();
        VersionHistory history = this.retrieveVersionHistory(item);
        actions.addButton("submit_version").setValue(T_submit_version);
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        main.addHidden("versioning-continue").setValue(this.knot.getId());
    }

    private Item getItem() throws SQLException {
        int itemID = this.parameters.getParameterAsInteger("itemID", -1);
        return Item.find((Context)this.context, (int)itemID);
    }

    private VersionHistory retrieveVersionHistory(Item item) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        return versioningService.findVersionHistory(this.context, item.getID());
    }
}

