/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersioningService;

public class VersionUpdateForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = VersionUpdateForm.message("xmlui.general.dspace_home");
    private static final Message T_submit_cancel = VersionUpdateForm.message("xmlui.general.cancel");
    private static final Message T_title = VersionUpdateForm.message("xmlui.aspect.versioning.VersionUpdateForm.title");
    private static final Message T_trail = VersionUpdateForm.message("xmlui.aspect.versioning.VersionUpdateForm.trail");
    private static final Message T_head1 = VersionUpdateForm.message("xmlui.aspect.versioning.VersionUpdateForm.head1");
    private static final Message T_submit_version = VersionUpdateForm.message("xmlui.aspect.versioning.VersionUpdateForm.submit_version");
    private static final Message T_submit_update_version = VersionUpdateForm.message("xmlui.aspect.versioning.VersionUpdateForm.submit_update_version");
    private static final Message T_summary = VersionUpdateForm.message("xmlui.aspect.versioning.VersionUpdateForm.summary");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException {
        int versionID = this.parameters.getParameterAsInteger("versionID", -1);
        int itemID = this.parameters.getParameterAsInteger("itemID", -1);
        Version version = this.getVersion(versionID);
        Item item = Item.find((Context)this.context, (int)itemID);
        Division main = body.addInteractiveDivision("version-item", this.contextPath + "/item/versionhistory", "post", "primary administrative version");
        if (item != null) {
            main.setHead(T_head1.parameterize(item.getHandle()));
        }
        List fields = main.addList("fields", "form");
        Composite addComposite = fields.addItem().addComposite("summary");
        addComposite.setLabel(T_summary);
        TextArea addValue = addComposite.addTextArea("summary");
        addValue.setValue(version.getSummary());
        Para actions = main.addPara();
        actions.addButton("submit_update").setValue(T_submit_update_version);
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        main.addHidden("versioning-continue").setValue(this.knot.getId());
    }

    private Version getVersion(int versionID) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        return versioningService.getVersion(this.context, versionID);
    }
}

