/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmltest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Instance;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.xml.sax.SAXException;

public class AdvancedFormTest
extends AbstractDSpaceTransformer {
    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent("Advanced Form Test");
        pageMeta.addTrailLink(this.contextPath + "/", "DSpace Home");
        pageMeta.addTrail().addContent("Advanced Form Test");
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        boolean help = false;
        boolean error = false;
        if (request.getParameter("help") != null) {
            help = true;
        }
        if (request.getParameter("error") != null) {
            error = true;
        }
        Division div = body.addInteractiveDivision("test", "", "post", "primary");
        div.setHead("Advanced form test");
        div.addPara("There are two options you can use to control how this page is generated. First is the help parameter, if this is present then help text will be provided for all fields. Next is the error parameter, if it is provided then all fields will be generated in error conditions.");
        if (help) {
            div.addPara().addXref(this.makeURL(false, error), "Turn help OFF");
        } else {
            div.addPara().addXref(this.makeURL(true, error), "Turn help ON");
        }
        if (error) {
            div.addPara().addXref(this.makeURL(help, false), "Turn errors OFF");
        } else {
            div.addPara().addXref(this.makeURL(help, true), "Turn errors ON");
        }
        List list = div.addList("fieldTest", "form");
        list.setHead("Tests");
        Text text = list.addItem().addText("text");
        text.setLabel("Text");
        text.enableAddOperation();
        text.enableDeleteOperation();
        if (help) {
            text.setHelp("This is helpful text.");
        }
        if (error) {
            text.addError("This field is in error.");
        }
        text.setValue("First is special");
        Instance instance = text.addInstance();
        instance.setValue("Second raw");
        instance.setInterpretedValue("Second interpreted");
        instance = text.addInstance();
        instance.setValue("Third raw");
        instance.setInterpretedValue("Third interpreted");
        Select select = list.addItem().addSelect("select");
        select.setLabel("Text");
        select.enableAddOperation();
        select.enableDeleteOperation();
        select.setMultiple();
        select.setSize(4);
        if (help) {
            select.setHelp("This is helpful text.");
        }
        if (error) {
            select.addError("This field is in error.");
        }
        select.addOption("one", "uno");
        select.addOption("two", "dos");
        select.addOption("three", "tres");
        select.addOption("four", "cuatro");
        select.addOption("five", "cinco");
        instance = select.addInstance();
        instance.setOptionSelected("one");
        instance = select.addInstance();
        instance.setOptionSelected("one");
        instance.setOptionSelected("two");
        instance = select.addInstance();
        instance.setOptionSelected("one");
        instance.setOptionSelected("two");
        instance.setOptionSelected("three");
        instance = select.addInstance();
        instance.setOptionSelected("one");
        instance.setOptionSelected("two");
        instance.setOptionSelected("three");
        instance.setOptionSelected("four");
        instance = select.addInstance();
        instance.setOptionSelected("one");
        instance.setOptionSelected("two");
        instance.setOptionSelected("three");
        instance.setOptionSelected("four");
        instance.setOptionSelected("five");
        Composite composite = list.addItem().addComposite("compositeA");
        composite.setLabel("Composite (two text fields)");
        composite.enableAddOperation();
        composite.enableDeleteOperation();
        if (help) {
            composite.setHelp("This field is composed of two text fields, fill them both in.");
        }
        if (error) {
            composite.addError("Just the composite is in error.");
        }
        text = composite.addText("firstA");
        if (help) {
            text.setHelp("This is helpful text.");
        }
        text.addInstance().setValue("1, Raw A");
        text.addInstance().setValue("2, Raw A");
        text.addInstance().setValue("3, Raw A");
        text = composite.addText("secondA");
        if (help) {
            text.setHelp("This is helpful text.");
        }
        text.addInstance().setValue("1, Raw B");
        text.addInstance().setValue("2, Raw B");
        text.addInstance().setValue("3, Raw B");
        composite = list.addItem().addComposite("compositeB");
        composite.setLabel("Composite (select & text fields)");
        composite.enableAddOperation();
        composite.enableDeleteOperation();
        if (help) {
            composite.setHelp("This field is composed of a select and text field, select one and type the other.");
        }
        select = composite.addSelect("selectB");
        if (help) {
            select.setHelp("Me, me, me..... select me!");
        }
        if (error) {
            select.addError("The composite elements are in error.");
        }
        select.addOption("one", "uno");
        select.addOption("two", "dos");
        select.addOption("three", "tres");
        select.addOption("four", "cuatro");
        select.addOption("five", "cinco");
        select.setOptionSelected("one");
        select.addInstance().addOptionValue("one");
        select.addInstance().addOptionValue("two");
        select.addInstance().addOptionValue("three");
        text = composite.addText("TextB");
        if (help) {
            text.setHelp("Yay, yet another text field");
        }
        if (error) {
            text.addError("The composite elements are in error.");
        }
        text.addInstance().setValue("1, Raw B");
        text.addInstance().setValue("2, Raw B");
        text.addInstance().setValue("3, Raw B");
        composite.addInstance().setInterpretedValue("One interpreted.");
        composite.addInstance().setInterpretedValue("Two interpreted.");
        composite.addInstance().setInterpretedValue("Three interpreted.");
        composite = list.addItem().addComposite("composite-date");
        composite.setLabel("Composite (date)");
        composite.enableAddOperation();
        composite.enableDeleteOperation();
        if (help) {
            composite.setHelp("The date when something happened.");
        }
        if (error) {
            composite.setHelp("The composite is in error.");
        }
        text = composite.addText("day");
        if (help) {
            text.setHelp("day");
        }
        if (error) {
            text.setHelp("The first text field is in error.");
        }
        text.setSize(4, 2);
        text.addInstance().setValue("1");
        text.addInstance().setValue("2");
        text.addInstance().setValue("3");
        text.addInstance().setValue("4");
        text.addInstance().setValue("5");
        select = composite.addSelect("month");
        if (error) {
            select.setHelp("The select box is in error.");
        }
        select.addOption("", "(Select Month)");
        select.addOption(1, "January");
        select.addOption(2, "Feburary");
        select.addOption(3, "March");
        select.addOption(4, "April");
        select.addOption(5, "May");
        select.addOption(6, "June");
        select.addOption(7, "July");
        select.addOption(8, "August");
        select.addOption(9, "September");
        select.addOption(10, "August");
        select.addOption(11, "October");
        select.addOption(12, "November");
        select.addOption(13, "December");
        select.addInstance().setOptionSelected(1);
        select.addInstance().setOptionSelected(2);
        select.addInstance().setOptionSelected(3);
        select.addInstance().setOptionSelected(4);
        select.addInstance().setOptionSelected(5);
        text = composite.addText("year");
        text.setSize(4, 4);
        if (help) {
            text.setHelp("year");
        }
        if (error) {
            text.setHelp("The second text field is in error.");
        }
        text.addInstance().setValue("2001");
        text.addInstance().setValue("2002");
        text.addInstance().setValue("2003");
        text.addInstance().setValue("2004");
        text.addInstance().setValue("2005");
        Item actions = list.addItem();
        actions.addButton("submit_save").setValue("Save");
        actions.addButton("submit_cancel").setValue("Cancel");
    }

    private String makeURL(boolean help, boolean error) {
        if (help && error) {
            return "?help&error";
        }
        if (help) {
            return "?help";
        }
        if (error) {
            return "?error";
        }
        return "?neither";
    }
}

