/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.i18n.I18nUtils;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;

public class DSpaceLocaleAction
extends ServiceableAction
implements Configurable {
    private static DSpaceLocaleValidator localeValidator;
    private static Locale defaultLocale;

    public void configure(Configuration config) {
        if (localeValidator == null) {
            localeValidator = new DSpaceLocaleValidator();
        }
        if (defaultLocale == null) {
            defaultLocale = I18nUtil.getDefaultLocale();
        }
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Locale locale = I18nUtils.findLocale((Map)objectModel, (String)"locale-attribute", (Parameters)parameters, (Locale)defaultLocale, (boolean)false, (boolean)true, (boolean)false, (I18nUtils.LocaleValidator)localeValidator);
        if (locale == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"No locale found, using default");
            }
            locale = I18nUtil.getDefaultLocale();
        }
        String localeStr = locale.toString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Found locale: " + localeStr));
        }
        I18nUtils.storeLocale((Map)objectModel, (String)"locale-attribute", (String)localeStr, (boolean)false, (boolean)true, (boolean)false, (boolean)false);
        Context context = ContextUtil.obtainContext(objectModel);
        context.setCurrentLocale(locale);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("language", locale.getLanguage());
        map.put("country", locale.getCountry());
        map.put("variant", locale.getVariant());
        map.put("locale", localeStr);
        return map;
    }

    public static class DSpaceLocaleValidator
    implements I18nUtils.LocaleValidator {
        private List<Locale> supportedLocales;

        public DSpaceLocaleValidator() {
            if (ConfigurationManager.getProperty((String)"webui.supported.locales") != null) {
                String[] parts;
                this.supportedLocales = new ArrayList<Locale>();
                String supportedLocalesConfig = ConfigurationManager.getProperty((String)"webui.supported.locales");
                for (String part : parts = supportedLocalesConfig.split(",")) {
                    Locale supportedLocale = I18nUtils.parseLocale((String)part.trim(), null);
                    if (supportedLocale == null) continue;
                    this.supportedLocales.add(supportedLocale);
                }
            }
        }

        public boolean test(String name, Locale test) {
            if (this.supportedLocales == null) {
                return true;
            }
            for (Locale locale : this.supportedLocales) {
                if (!locale.equals(test)) continue;
                return true;
            }
            return false;
        }
    }
}

