/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2Impl;

public class NamespaceFilterTransformer
extends AbstractTransformer
implements CacheableProcessingComponent {
    private String filterNamespace;
    private Stack<String> filterPrefixes = new Stack();

    public Serializable getKey() {
        if (this.filterNamespace != null) {
            return this.filterNamespace;
        }
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.filterNamespace = src;
        this.filterPrefixes.clear();
    }

    private boolean filter(String test) {
        return this.filterNamespace != null && this.filterNamespace.equals(test);
    }

    private boolean filterPrefix(String test) {
        if (this.filterPrefixes.isEmpty()) {
            return false;
        }
        String peek = this.filterPrefixes.peek();
        return peek != null && peek.equals(test);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.filter(uri)) {
            this.filterPrefixes.push(prefix);
        } else {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.filterPrefix(prefix)) {
            this.filterPrefixes.pop();
        } else {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (!this.filter(uri)) {
            ArrayList<Integer> filterAttributeIndexes = new ArrayList<Integer>();
            for (int i = 0; i < a.getLength(); ++i) {
                if (!this.filter(a.getURI(i))) continue;
                filterAttributeIndexes.add(i);
            }
            if (!filterAttributeIndexes.isEmpty()) {
                Attributes2Impl a2 = new Attributes2Impl();
                for (int i = 0; i < a.getLength(); ++i) {
                    if (filterAttributeIndexes.contains(i)) continue;
                    String a_uri = a.getURI(i);
                    String a_localName = a.getLocalName(i);
                    String a_qName = a.getQName(i);
                    String a_type = a.getType(i);
                    String a_value = a.getValue(i);
                    a2.addAttribute(a_uri, a_localName, a_qName, a_type, a_value);
                }
                a = a2;
            }
            this.contentHandler.startElement(uri, loc, raw, a);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (!this.filter(uri)) {
            this.contentHandler.endElement(uri, loc, raw);
        }
    }
}

