/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Include
extends AbstractTransformer
implements CacheableProcessingComponent {
    private static final Map<String, String[]> mergeableMap;
    private Document w3cDocument;
    private DOMStreamer streamer;
    private Stack<Element> stack;
    private Source source;
    private String src;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.src = src;
        this.source = resolver.resolveURI(src);
    }

    public Serializable getKey() {
        return this.src;
    }

    public SourceValidity getValidity() {
        if (this.source != null) {
            if (this.source.exists()) {
                return this.source.getValidity();
            }
            return NOPValidity.SHARED_INSTANCE;
        }
        return null;
    }

    public void startDocument() throws SAXException {
        try {
            this.w3cDocument = SourceUtil.toDOM((Source)this.source);
        }
        catch (Exception e) {
            this.getLogger().warn((Object)("File to be included from " + this.source.toString() + " not found."));
            this.stack = null;
            super.startDocument();
            return;
        }
        this.stack = new Stack();
        this.streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.stack = null;
        super.endDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.stack != null) {
            if (this.stack.size() == 0) {
                this.stack.push(this.w3cDocument.getDocumentElement());
            } else {
                Element peek = this.stack.peek();
                Element foundChild = null;
                for (Element child : Include.getElementList(peek)) {
                    if (!this.isEqual(child, uri, localName, qName, attributes)) continue;
                    foundChild = child;
                }
                if (foundChild != null) {
                    peek.removeChild(foundChild);
                }
                this.stack.push(foundChild);
            }
        }
        super.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Element poped;
        if (this.stack != null && (poped = this.stack.pop()) != null) {
            for (Node node : Include.getNodeList(poped)) {
                this.streamer.stream(node);
            }
        }
        super.endElement(uri, localName, qName);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        super.characters(c, start, len);
    }

    private boolean isEqual(Element child, String uri, String localName, String qName, Attributes attributes) {
        if (child == null) {
            return false;
        }
        if (uri != null && !uri.equals(child.getNamespaceURI())) {
            return false;
        }
        if (localName != null && !localName.equals(child.getLocalName())) {
            return false;
        }
        if (!mergeableMap.containsKey(localName)) {
            return false;
        }
        String[] attributeIdentities = mergeableMap.get(localName);
        if (attributeIdentities != null) {
            for (String attributeIdentity : attributeIdentities) {
                String testIdentity = attributes.getValue(attributeIdentity);
                String childIdentity = child.getAttribute(attributeIdentity);
                if (childIdentity != null && childIdentity.equals(testIdentity) || childIdentity == null && testIdentity == null) continue;
                return false;
            }
        }
        return true;
    }

    private static List<Element> getElementList(Element element) {
        if (element == null) {
            return new ArrayList<Element>();
        }
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> resultList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            resultList.add((Element)nodeList.item(i));
        }
        return resultList;
    }

    private static List<Node> getNodeList(Element element) {
        if (element == null) {
            return new ArrayList<Node>();
        }
        NodeList nodeList = element.getChildNodes();
        ArrayList<Node> resultList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            resultList.add(nodeList.item(i));
        }
        return resultList;
    }

    public void recycle() {
        this.w3cDocument = null;
        this.streamer = null;
        this.stack = null;
        this.source = null;
        super.recycle();
    }

    static {
        HashMap<String, String[]> buildMap = new HashMap<String, String[]>();
        buildMap.put("document", null);
        buildMap.put("meta", null);
        buildMap.put("userMeta", null);
        buildMap.put("pageMeta", null);
        buildMap.put("artifactmeta", null);
        buildMap.put("repositoryMeta", null);
        buildMap.put("community", new String[]{"repositoryIdentifier"});
        buildMap.put("collection", new String[]{"repositoryIdentifier"});
        buildMap.put("body", null);
        buildMap.put("options", null);
        buildMap.put("list", new String[]{"n"});
        mergeableMap = buildMap;
    }
}

