/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.springmvc;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierService;
import org.dspace.springmvc.BibTexView;
import org.dspace.springmvc.RisView;
import org.dspace.utils.DSpace;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Controller
@RequestMapping(value={"/handle", "/resource"})
public class ResourceIdentifierController {
    public static final String DSPACE_OBJECT = "dspace.object";
    private static final String RESOURCE = "/resource";
    private static final String METS = "mets";
    private static final String DRI = "DRI";
    private static final int STATUS_OK = 200;
    private static final int STATUS_FORBIDDEN = 400;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD}, value={"/{prefix:.*}"})
    public String processHandle(HttpServletRequest request, @PathVariable String prefix) {
        try {
            Context context = ContextUtil.obtainContext(request);
            IdentifierService dis = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
            if (dis == null) {
                throw new RuntimeException("Cannot instantiate IdentifierService. Problem with spring configuration!");
            }
            DSpaceObject dso = dis.resolve(context, prefix);
            if (dso == null) {
                throw new RuntimeException("Cannot find Item!");
            }
            request.setAttribute(DSPACE_OBJECT, (Object)dso);
            return "forward:/handle/" + dso.getHandle();
        }
        catch (SQLException e) {
            return "forward:/error";
        }
        catch (IdentifierNotResolvableException e) {
            return "forward:/tombstone";
        }
        catch (IdentifierNotFoundException e) {
            request.setAttribute("identifier", (Object)prefix);
            return "forward:/identifier-not-found";
        }
    }

    @RequestMapping(value={"/**/mets.xml"})
    public String processMETSHandle(HttpServletRequest request) {
        try {
            String requestUri = request.getRequestURI().toString();
            String resourceIdentifier = requestUri.substring(requestUri.indexOf(RESOURCE) + RESOURCE.length() + 1);
            resourceIdentifier = resourceIdentifier.substring(0, resourceIdentifier.indexOf(METS) - 1);
            Context context = ContextUtil.obtainContext(request);
            IdentifierService dis = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
            DSpaceObject dso = dis.resolve(context, resourceIdentifier);
            if (dso == null) {
                return null;
            }
            request.setAttribute(DSPACE_OBJECT, (Object)dso);
            return "forward:/metadata/handle/" + dso.getHandle() + "/mets.xml";
        }
        catch (SQLException e) {
            return "forward:/error";
        }
        catch (IdentifierNotResolvableException e) {
            return "forward:/tombstone";
        }
        catch (IdentifierNotFoundException e) {
            return "forward:/identifier-not-found";
        }
    }

    @RequestMapping(value={"/**/DRI"})
    public String processDRIHandle(HttpServletRequest request) {
        try {
            String requestUri = request.getRequestURI().toString();
            String resourceIdentifier = requestUri.substring(requestUri.indexOf(RESOURCE) + RESOURCE.length() + 1);
            resourceIdentifier = resourceIdentifier.substring(0, resourceIdentifier.indexOf(DRI) - 1);
            Context context = ContextUtil.obtainContext(request);
            IdentifierService dis = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
            DSpaceObject dso = dis.resolve(context, resourceIdentifier);
            if (dso == null) {
                return null;
            }
            request.setAttribute(DSPACE_OBJECT, (Object)dso);
            return "forward:/DRI/handle/" + dso.getHandle();
        }
        catch (SQLException e) {
            return "forward:/error";
        }
        catch (IdentifierNotResolvableException e) {
            return "forward:/tombstone";
        }
        catch (IdentifierNotFoundException e) {
            return "forward:/identifier-not-found";
        }
    }

    @RequestMapping(value={"/{prefix}/{suffix}/citation/ris"})
    public ModelAndView genRisRepresentation(@PathVariable String prefix, @PathVariable String suffix, HttpServletRequest request, HttpServletResponse response) {
        String resourceIdentifier = prefix + "/" + suffix;
        request.setAttribute(DSPACE_OBJECT, (Object)this.getDSO(request, resourceIdentifier));
        return new ModelAndView((View)new RisView(resourceIdentifier));
    }

    @RequestMapping(value={"/{prefix}/{suffix}/citation/bib"})
    public ModelAndView genBibTexRepresentation(@PathVariable String prefix, @PathVariable String suffix, HttpServletRequest request, HttpServletResponse response) {
        String resourceIdentifier = prefix + "/" + suffix;
        request.setAttribute(DSPACE_OBJECT, (Object)this.getDSO(request, resourceIdentifier));
        return new ModelAndView((View)new BibTexView(resourceIdentifier));
    }

    private DSpaceObject getDSO(HttpServletRequest request, String resourceIdentifier) {
        DSpaceObject dso = null;
        IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            dso = identifierService.resolve(context, resourceIdentifier);
            if (dso == null) {
                throw new RuntimeException("Invalid DOI! " + resourceIdentifier);
            }
            return dso;
        }
        catch (IdentifierNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IdentifierNotResolvableException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private int validate(String resourceID, HttpServletRequest request) {
        String token = request.getParameter("token");
        if (token == null || "".equals(token)) {
            return 400;
        }
        if (resourceID == null || "".equals(resourceID)) {
            return 400;
        }
        DSpaceObject dso = null;
        IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            dso = identifierService.resolve(context, resourceID);
            request.setAttribute(DSPACE_OBJECT, (Object)dso);
            if (!(dso instanceof Item)) {
                return 400;
            }
            return 200;
        }
        catch (SQLException e) {
            return 400;
        }
        catch (IdentifierNotFoundException e) {
            return 400;
        }
        catch (IdentifierNotResolvableException e) {
            return 400;
        }
    }
}

