/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;

public class FlowMapperUtils {
    private static final Message T_map_items = new Message("default", "xmlui.administrative.FlowMapperUtils.map_items");
    private static final Message T_unmaped_items = new Message("default", "xmlui.administrative.FlowMapperUtils.unmaped_items");

    public static FlowResult processMapItems(Context context, int collectionID, String[] itemIDs) throws SQLException, AuthorizeException, UIException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Collection toCollection = Collection.find((Context)context, (int)collectionID);
        for (String itemID : itemIDs) {
            Item item = Item.find((Context)context, (int)Integer.valueOf(itemID));
            if (!AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)item, (int)0) || item.isOwningCollection(toCollection)) continue;
            toCollection.addItem(item);
            try {
                IndexBrowse ib = new IndexBrowse(context);
                ib.indexItem(item);
            }
            catch (BrowseException bex) {
                throw new UIException("Unable to process browse", (Throwable)bex);
            }
        }
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_map_items);
        return result;
    }

    public static FlowResult processUnmapItems(Context context, int collectionID, String[] itemIDs) throws SQLException, AuthorizeException, UIException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Collection toCollection = Collection.find((Context)context, (int)collectionID);
        for (String itemID : itemIDs) {
            Item item = Item.find((Context)context, (int)Integer.valueOf(itemID));
            if (!AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)item, (int)0) || item.isOwningCollection(toCollection)) continue;
            toCollection.removeItem(item);
            try {
                IndexBrowse ib = new IndexBrowse(context);
                ib.indexItem(item);
            }
            catch (BrowseException bex) {
                throw new UIException("Unable to process browse", (Throwable)bex);
            }
        }
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_unmaped_items);
        return result;
    }
}

