/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.authorization;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Highlight;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class EditContainerPolicies
extends AbstractDSpaceTransformer {
    private static final Message T_title = EditContainerPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.title");
    private static final Message T_policyList_trail = EditContainerPolicies.message((String)"xmlui.administrative.authorization.general.policyList_trail");
    private static final Message T_authorize_trail = EditContainerPolicies.message((String)"xmlui.administrative.authorization.general.authorize_trail");
    private static final Message T_main_head_collection = EditContainerPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.main_head_collection");
    private static final Message T_main_head_community = EditContainerPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.main_head_community");
    private static final Message T_add_link = EditContainerPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.main_add_link");
    private static final Message T_head_id = EditContainerPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.head_id");
    private static final Message T_head_action = EditContainerPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.head_action");
    private static final Message T_head_group = EditContainerPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.head_group");
    private static final Message T_group_edit = EditContainerPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.group_edit");
    private static final Message T_submit_delete = EditContainerPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.submit_delete");
    private static final Message T_submit_return = EditContainerPolicies.message((String)"xmlui.general.return");
    private static final Message T_dspace_home = EditContainerPolicies.message((String)"xmlui.general.dspace_home");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/authorize", T_authorize_trail);
        pageMeta.addTrail().addContent(T_policyList_trail);
    }

    public void addBody(Body body) throws WingException, SQLException {
        ArrayList policies;
        int containerType = this.parameters.getParameterAsInteger("containerType", -1);
        int containerID = this.parameters.getParameterAsInteger("containerID", -1);
        int highlightID = this.parameters.getParameterAsInteger("highlightID", -1);
        String baseURL = this.contextPath + "/admin/epeople?administrative-continue=" + this.knot.getId();
        Division main = body.addInteractiveDivision("edit-container-policies", this.contextPath + "/admin/authorize", "post", "primary administrative authorization");
        if (containerType == 3) {
            Collection col = Collection.find((Context)this.context, (int)containerID);
            main.setHead(T_main_head_collection.parameterize(new Object[]{col.getMetadata("name"), col.getHandle(), col.getID()}));
            policies = (ArrayList)AuthorizeManager.getPolicies((Context)this.context, (DSpaceObject)col);
        } else {
            Community com = Community.find((Context)this.context, (int)containerID);
            main.setHead(T_main_head_community.parameterize(new Object[]{com.getMetadata("name"), com.getHandle(), com.getID()}));
            policies = (ArrayList)AuthorizeManager.getPolicies((Context)this.context, (DSpaceObject)com);
        }
        main.addPara().addXref(baseURL + "&submit_add", T_add_link);
        Table table = main.addTable("container-policy-list", policies.size() + 1, 4);
        Row header = table.addRow("header");
        header.addCell();
        header.addCell().addContent(T_head_id);
        header.addCell().addContent(T_head_action);
        header.addCell().addContent(T_head_group);
        if (policies != null) {
            for (ResourcePolicy policy : policies) {
                Row row = policy.getID() == highlightID ? table.addRow(null, null, "highlight") : table.addRow();
                CheckBox select = row.addCell().addCheckBox("select_policy");
                select.setLabel(String.valueOf(policy.getID()));
                select.addOption(String.valueOf(policy.getID()));
                Group policyGroup = policy.getGroup();
                row.addCell().addXref(baseURL + "&submit_edit&policy_id=" + policy.getID(), String.valueOf(policy.getID()));
                row.addCell().addXref(baseURL + "&submit_edit&policy_id=" + policy.getID(), policy.getActionText());
                if (policyGroup != null) {
                    Cell groupCell = row.addCell();
                    groupCell.addContent(policyGroup.getName());
                    Highlight groupHigh = groupCell.addHighlight("fade");
                    groupHigh.addContent(" [");
                    groupHigh.addXref(baseURL + "&submit_edit_group&group_id=" + policyGroup.getID(), T_group_edit);
                    groupHigh.addContent("]");
                    continue;
                }
                row.addCell().addContent("...");
            }
        }
        Para buttons = main.addPara();
        buttons.addButton("submit_delete").setValue(T_submit_delete);
        buttons.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

