/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class RestrictedItem
extends AbstractDSpaceTransformer {
    private static final Logger log = Logger.getLogger(RestrictedItem.class);
    private static final Message T_title = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.title");
    private static final Message T_dspace_home = RestrictedItem.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.trail");
    private static final Message T_head_resource = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_resource");
    private static final Message T_head_community = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_community");
    private static final Message T_head_collection = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_collection");
    private static final Message T_head_item = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_item");
    private static final Message T_head_item_withdrawn = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_item_withdrawn");
    private static final Message T_head_bitstream = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_bitstream");
    private static final Message T_para_resource = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_resource");
    private static final Message T_para_community = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_community");
    private static final Message T_para_collection = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_collection");
    private static final Message T_para_item = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_item");
    private static final Message T_para_bitstream = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_bitstream");
    private static final Message T_para_item_restricted_auth = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_item_restricted_auth");
    private static final Message T_para_item_restricted = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_item_restricted");
    private static final Message T_para_item_withdrawn = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_item_withdrawn");
    private static final Message T_para_login = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.login");

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        if (dso != null) {
            HandleUtil.buildHandleTrail((DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath);
        }
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException, ResourceNotFoundException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        Division unauthorized = null;
        boolean isWithdrawn = false;
        if (dso == null) {
            unauthorized = body.addDivision("unauthorized-resource", "primary");
            unauthorized.setHead(T_head_resource);
            unauthorized.addPara(T_para_resource);
        } else if (dso instanceof Community) {
            Community community = (Community)dso;
            unauthorized = body.addDivision("unauthorized-resource", "primary");
            unauthorized.setHead(T_head_community);
            unauthorized.addPara(T_para_community.parameterize(new Object[]{community.getMetadata("name")}));
        } else if (dso instanceof Collection) {
            Collection collection = (Collection)dso;
            unauthorized = body.addDivision("unauthorized-resource", "primary");
            unauthorized.setHead(T_head_collection);
            unauthorized.addPara(T_para_collection.parameterize(new Object[]{collection.getMetadata("name")}));
        } else if (dso instanceof Item) {
            String identifier;
            if (request.getParameter("bitstreamId") != null) {
                identifier = "unknown";
                try {
                    Bitstream bit = Bitstream.find((Context)this.context, (int)new Integer(request.getParameter("bitstreamId")));
                    if (bit != null) {
                        identifier = bit.getName();
                    }
                }
                catch (Exception e) {
                    log.trace((Object)"Caught exception", (Throwable)e);
                }
                unauthorized = body.addDivision("unauthorized-resource", "primary");
                unauthorized.setHead(T_head_bitstream);
                unauthorized.addPara(T_para_bitstream.parameterize(new Object[]{identifier}));
            } else {
                identifier = "unknown";
                String handle = dso.getHandle();
                identifier = handle == null || "".equals(handle) ? "internal ID: " + dso.getID() : "hdl:" + handle;
                String divID = "restricted";
                Message title = T_head_item;
                Message status = T_para_item_restricted;
                if (((Item)dso).isWithdrawn()) {
                    divID = "withdrawn";
                    title = T_head_item_withdrawn;
                    status = T_para_item_withdrawn;
                    isWithdrawn = true;
                } else if (this.context.getCurrentUser() == null) {
                    status = T_para_item_restricted_auth;
                }
                unauthorized = body.addDivision(divID, "primary");
                unauthorized.setHead(title);
                unauthorized.addPara(T_para_item.parameterize(new Object[]{identifier}));
                unauthorized.addPara("item_status", status.getKey()).addContent(status);
            }
        } else {
            unauthorized = body.addDivision("unauthorized-resource", "primary");
            unauthorized.setHead(T_head_resource);
            unauthorized.addPara(T_para_resource);
        }
        if (!isWithdrawn && this.context.getCurrentUser() == null) {
            unauthorized.addPara().addXref(this.contextPath + "/login", T_para_login);
            String header = this.parameters.getParameter("header", null);
            String message = this.parameters.getParameter("message", null);
            String characters = this.parameters.getParameter("characters", null);
            AuthenticationUtil.interruptRequest((Map)this.objectModel, (String)header, (String)message, (String)characters);
        }
        HttpServletResponse response = (HttpServletResponse)this.objectModel.get("httpresponse");
        response.setStatus(404);
    }
}

