/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery.recentSubmissions;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.aspect.discovery.recentSubmissions.RecentSubmissionUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Metadata;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverResult;
import org.xml.sax.SAXException;

public class RecentSubmissionTransformer
extends AbstractDSpaceTransformer {
    protected static final Message T_dspace_home = RecentSubmissionTransformer.message((String)"xmlui.general.dspace_home");
    protected static final Message T_untitled = RecentSubmissionTransformer.message((String)"xmlui.general.untitled");
    protected static final Message T_head = RecentSubmissionTransformer.message((String)"xmlui.Discovery.RecentSubmissions.RecentSubmissionTransformer.head");
    protected static final Message T_recent_submission_head = RecentSubmissionTransformer.message((String)"xmlui.Discovery.RecentSubmissions.RecentSubmissionTransformer.recent.head");
    protected static final Message T_trail = RecentSubmissionTransformer.message((String)"xmlui.Discovery.RecentSubmissions.RecentSubmissionTransformer.trail");
    protected boolean isHomePage = false;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.isHomePage = parameters.getParameterAsBoolean("isHomePage", false);
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String formats;
        DSpaceObject dso = this.getDSpaceObject();
        String name = dso.getName();
        Metadata titlePageMeta = pageMeta.addMetadata("title");
        if (name == null || name.length() == 0) {
            if (this.isHomePage) {
                titlePageMeta.addContent(T_untitled);
            } else {
                titlePageMeta.addContent(T_recent_submission_head.parameterize(new Object[]{name}));
            }
        } else if (this.isHomePage) {
            titlePageMeta.addContent(name);
        } else {
            titlePageMeta.addContent(T_recent_submission_head.parameterize(new Object[]{name}));
        }
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        HandleUtil.buildHandleTrail((DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath, (!this.isHomePage ? 1 : 0) != 0);
        if (!this.isHomePage) {
            pageMeta.addTrail().addContent(T_trail);
        }
        if (this.isHomePage && (formats = ConfigurationManager.getProperty((String)"webui.feed.formats")) != null) {
            for (String format : formats.split(",")) {
                String[] parts = format.split("_");
                if (parts.length < 1) continue;
                String feedFormat = parts[0].trim() + "+xml";
                String feedURL = this.contextPath + "/feed/" + format.trim() + "/" + dso.getHandle();
                pageMeta.addMetadata("feed", feedFormat).addContent(feedURL);
            }
        }
    }

    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = this.getDSpaceObject();
        Division mainDivision = body.addDivision("main-recent-submissions");
        this.setMainTitle(dso, mainDivision);
        Division recentSubmissionDivision = mainDivision.addDivision("recent-submissions");
        if (this.isHomePage) {
            recentSubmissionDivision.setHead(T_recent_submission_head);
        }
        DiscoverResult recentlySubmittedItems = RecentSubmissionUtils.getRecentlySubmittedItems((Context)this.context, (DSpaceObject)dso, (int)this.getOffset(request));
        this.setPagination(request, dso, recentSubmissionDivision, recentlySubmittedItems);
        ReferenceSet lastSubmitted = recentSubmissionDivision.addReferenceSet("last-submitted", "summaryList", null, "recent-submissions");
        for (DSpaceObject resultObject : recentlySubmittedItems.getDspaceObjects()) {
            if (resultObject == null) continue;
            lastSubmitted.addReference((Object)resultObject);
        }
    }

    protected void setPagination(Request request, DSpaceObject dso, Division mainDivision, DiscoverResult recentlySubmittedItems) {
        int offset = this.getOffset(request);
        int rpp = RecentSubmissionUtils.getRecentSubmissionConfiguration((DSpaceObject)dso).getMax();
        int firstIndex = offset + 1;
        int lastIndex = offset + recentlySubmittedItems.getDspaceObjects().size();
        mainDivision.setSimplePagination((int)recentlySubmittedItems.getTotalSearchResults(), firstIndex, lastIndex, this.getPreviousPageURL(dso, offset, rpp), this.getNextPageURL(dso, offset, rpp, (int)recentlySubmittedItems.getTotalSearchResults()));
    }

    protected void setMainTitle(DSpaceObject dso, Division mainDivision) throws WingException {
        String title = dso.getName();
        if (this.isHomePage) {
            mainDivision.setHead(title);
        } else {
            mainDivision.setHead(T_head.parameterize(new Object[]{title}));
        }
    }

    protected String getNextPageURL(DSpaceObject dso, int currentOffset, int rpp, int total) {
        if (rpp + currentOffset < total) {
            return this.getBaseUrl(dso) + "?offset=" + (rpp + currentOffset);
        }
        return null;
    }

    protected String getPreviousPageURL(DSpaceObject dso, int currentOffset, int rpp) {
        if (currentOffset - rpp < 0) {
            return null;
        }
        return this.getBaseUrl(dso) + "?offset=" + (currentOffset - rpp);
    }

    protected String getBaseUrl(DSpaceObject dso) {
        String url = this.contextPath;
        if (dso != null && dso.getID() != 0) {
            url = url + "/handle/" + dso.getHandle();
        }
        if (!this.isHomePage) {
            url = url + "/recent-submissions";
        }
        return url;
    }

    protected int getOffset(Request request) {
        int start = Util.getIntParameter((HttpServletRequest)request, (String)"offset");
        if (start == -1) {
            start = 0;
        }
        return start;
    }

    protected DSpaceObject getDSpaceObject() throws SQLException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso == null) {
            return Site.find((Context)this.context, (int)0);
        }
        return dso;
    }
}

