/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;
import org.xml.sax.SAXException;

public class VersionNoticeTransformer
extends AbstractDSpaceTransformer {
    private static final Message T_new_version_head = VersionNoticeTransformer.message((String)"xmlui.aspect.versioning.VersionNoticeTransformer.notice.new_version_head");
    private static final Message T_new_version_help = VersionNoticeTransformer.message((String)"xmlui.aspect.versioning.VersionNoticeTransformer.notice.new_version_help");
    private static final Message T_workflow_version_head = VersionNoticeTransformer.message((String)"xmlui.aspect.versioning.VersionNoticeTransformer.notice.workflow_version_head");
    private static final Message T_workflow_version_help = VersionNoticeTransformer.message((String)"xmlui.aspect.versioning.VersionNoticeTransformer.notice.workflow_version_help");
    private static Logger log = Logger.getLogger(VersionNoticeTransformer.class);

    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException, ProcessingException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Item)) {
            return;
        }
        Item item = (Item)dso;
        if (item.isWithdrawn()) {
            return;
        }
        Division mainDivision = body.addDivision("item-view", "primary");
        String title = item.getName();
        if (title != null) {
            mainDivision.setHead(title);
        } else {
            mainDivision.setHead(item.getHandle());
        }
        try {
            Version latestVersion;
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            VersionHistory history = versioningService.findVersionHistory(this.context, item.getID());
            if (history != null && (latestVersion = this.retrieveLatestVersion(history, item)) != null && latestVersion.getItemID() != item.getID()) {
                Item latestVersionItem = latestVersion.getItem();
                if (latestVersionItem.isArchived()) {
                    this.addVersionNotice(mainDivision, latestVersionItem, T_new_version_head, T_new_version_help, true);
                } else {
                    this.addVersionNotice(mainDivision, latestVersionItem, T_workflow_version_head, T_workflow_version_help, false);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Version retrieveLatestVersion(VersionHistory history, Item item) throws SQLException {
        List allVersions = history.getVersions();
        for (Version version : allVersions) {
            if (!version.getItem().isArchived() && !AuthorizeManager.isAdmin((Context)this.context, (DSpaceObject)item.getOwningCollection())) continue;
            return version;
        }
        return null;
    }

    protected void addVersionNotice(Division division, Item item, Message head, Message content, boolean addItemUrl) throws WingException, SQLException {
        Division noticeDiv = division.addDivision("general-message", "version-notice notice neutral");
        noticeDiv.setHead(head);
        Para para = noticeDiv.addPara();
        para.addContent(content);
        if (addItemUrl) {
            String url = HandleManager.resolveToURL((Context)this.context, (String)item.getHandle());
            para.addXref(url, url);
        }
    }
}

