/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.cocoon.ProcessingException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;
import org.xml.sax.SAXException;

public class VersionViewer
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = VersionViewer.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = VersionViewer.message((String)"xmlui.Version.versionhistory.trail");

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        int versionId;
        Version version;
        boolean isItemView = this.parameters.getParameterAsInteger("itemID", -1) == -1;
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        VersionHistory vh = versioningService.findVersionByHistoryId(this.context, (version = versioningService.getVersion(this.context, versionId = this.parameters.getParameterAsInteger("versionID", -1))).getVersionHistoryID());
        Version latest = vh.getLatestVersion();
        Item item = latest.getItem();
        if (item != null) {
            String title = item.getMetadata((String)"dc.title")[0].value;
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
            HandleUtil.buildHandleTrail((DSpaceObject)item, (PageMeta)pageMeta, (String)this.contextPath);
            if (title != null && title.length() > 0) {
                pageMeta.addTrailLink(this.contextPath + "/handle/" + item.getHandle(), title);
            } else {
                pageMeta.addTrail().addContent("Item");
            }
            pageMeta.addTrail().addContent(T_trail);
        } else {
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
            pageMeta.addTrail().addContent(T_trail);
        }
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException, ProcessingException {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        int versionId = this.parameters.getParameterAsInteger("versionID", -1);
        Version version = versioningService.getVersion(this.context, versionId);
        VersionHistory vh = versioningService.findVersionByHistoryId(this.context, version.getVersionHistoryID());
        Version latest = vh.getLatestVersion();
        Item item = latest.getItem();
        String title = "";
        title = item != null ? title + "Version for Item: " + item.getHandle() : title + "Version for deleted Item : " + version.getHandle();
        Division division = body.addDivision("version-view", "primary");
        division.setHead(title);
        Bitstream bitstream = version.getAIPBitstream();
        if (bitstream != null) {
            ReferenceSet referenceSet = division.addReferenceSet("version-viewer", "detailView");
            referenceSet.addReference((Object)bitstream);
            Division restoreForm = division.addInteractiveDivision("restore-version", this.contextPath + "/restore-version", "post");
            List list = restoreForm.addList("version", "form");
            list.addItem().addHidden("versionId");
        } else {
            division.addPara("No revision found");
        }
        Division id = division.addDivision("version-id");
        id.setHead("Version Id");
        id.addPara().addContent(version != null ? Integer.toString(version.getVersionId()) : "No ID");
        Division number = division.addDivision("version-number");
        number.setHead("Version Number");
        number.addPara().addContent(version != null ? Integer.toString(version.getVersionNumber()) : "No Number");
        Division itemDiv = division.addDivision("version-item");
        itemDiv.setHead("Item Id");
        itemDiv.addPara().addContent(version != null ? Integer.toString(version.getItemID()) : "No Item Id");
        Division summary = division.addDivision("version-summary");
        summary.setHead("Version Summary");
        summary.addPara().addContent(version != null ? version.getSummary() : "No summary");
        Division date = division.addDivision("version-date");
        date.setHead("Version Create Date");
        date.addPara().addContent(version != null ? version.getVersionDate().toString() : "No Date");
        Division editor = division.addDivision("version-editor");
        editor.setHead("Version Editor");
        editor.addPara().addXref(version != null ? "mailto:" + version.getEperson().getEmail() : "", version != null ? version.getEperson().getFullName() : "No Editor");
        Division log = division.addDivision("version-log");
        log.setHead("Version Log");
        log.addPara().addContent(version != null ? version.getVerisonLog() : "No log");
    }
}

