/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

/*
 * Exception performing whole class analysis ignored.
 */
public class UsageLoggerAction
extends AbstractAction {
    public Map act(Redirector redirector, SourceResolver sourceResolver, Map objectModel, String string, Parameters parameters) throws Exception {
        try {
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            Context context = ContextUtil.obtainContext((Map)objectModel);
            DSpaceObject dso = HandleUtil.obtainHandle((Map)objectModel);
            if (dso == null) {
                dso = this.findBitstream(context, parameters);
            }
            UsageLoggerAction.logDspaceObject((Request)request, (DSpaceObject)dso, (Context)context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void logDspaceObject(Request request, DSpaceObject dso, Context context) {
        if (dso == null) {
            return;
        }
        try {
            new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, (HttpServletRequest)request, ContextUtil.obtainContext((HttpServletRequest)request), dso));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Bitstream findBitstream(Context context, Parameters par) throws SQLException {
        DSpaceObject dso;
        int itemID = par.getParameterAsInteger("itemID", -1);
        int bitstreamID = par.getParameterAsInteger("bitstreamID", -1);
        String handle = par.getParameter("handle", null);
        int sequence = par.getParameterAsInteger("sequence", -1);
        String name = par.getParameter("name", null);
        Bitstream bitstream = null;
        if (bitstreamID > -1) {
            bitstream = Bitstream.find((Context)context, (int)bitstreamID);
        } else if (itemID > -1) {
            Item item = Item.find((Context)context, (int)itemID);
            if (sequence > -1) {
                bitstream = this.findBitstreamBySequence(item, sequence);
            } else if (name != null) {
                bitstream = this.findBitstreamByName(item, name);
            }
        } else if (handle != null && (dso = HandleManager.resolveToObject((Context)context, (String)handle)) instanceof Item) {
            Item item = (Item)dso;
            if (sequence > -1) {
                bitstream = this.findBitstreamBySequence(item, sequence);
            } else if (name != null) {
                bitstream = this.findBitstreamByName(item, name);
            }
        }
        return bitstream;
    }

    private Bitstream findBitstreamBySequence(Item item, int sequence) throws SQLException {
        Bundle[] bundles;
        if (item == null) {
            return null;
        }
        for (Bundle bundle : bundles = item.getBundles()) {
            Bitstream[] bitstreams;
            for (Bitstream bitstream : bitstreams = bundle.getBitstreams()) {
                if (bitstream.getSequenceID() != sequence) continue;
                return bitstream;
            }
        }
        return null;
    }

    private Bitstream findBitstreamByName(Item item, String name) throws SQLException {
        if (name == null || item == null) {
            return null;
        }
        int maxDepthPathSearch = 3;
        if (ConfigurationManager.getProperty((String)"xmlui.html.max-depth-guess") != null) {
            maxDepthPathSearch = ConfigurationManager.getIntProperty((String)"xmlui.html.max-depth-guess");
        }
        for (int i = 0; i < maxDepthPathSearch + 1; ++i) {
            int indexOfLastSlash;
            Bundle[] bundles;
            for (Bundle bundle : bundles = item.getBundles()) {
                Bitstream[] bitstreams;
                for (Bitstream bitstream : bitstreams = bundle.getBitstreams()) {
                    if (!name.equals(bitstream.getName())) continue;
                    return bitstream;
                }
            }
            int indexOfSlash = name.indexOf(47);
            if (indexOfSlash < 0) {
                return null;
            }
            name = name.substring(indexOfSlash + 1);
            if (i != maxDepthPathSearch - 1 || (indexOfLastSlash = name.lastIndexOf(47)) <= -1) continue;
            name = name.substring(indexOfLastSlash + 1);
        }
        return null;
    }
}

