/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeedUtils {
    public static final Map<String, String> i18nLabels = FeedUtils.makeI18NLabels();
    private static final String I18N_PREFIX = "I18N:";
    private static final String I18N_NAMESPACE = "http://apache.org/cocoon/i18n/2.1";

    private static Map<String, String> makeI18NLabels() {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        labelMap.put("notitle", "I18N:xmlui.feed.untitled");
        labelMap.put("logo.title", "I18N:xmlui.feed.logo_title");
        labelMap.put("general-feed.description", "I18N:xmlui.feed.general_description");
        labelMap.put("ui.type", "xmlui");
        return labelMap;
    }

    public static void unmangleI18N(Document dom) {
        NodeList elementNodes = dom.getElementsByTagName("*");
        for (int i = 0; i < elementNodes.getLength(); ++i) {
            NodeList textNodes = elementNodes.item(i).getChildNodes();
            for (int j = 0; j < textNodes.getLength(); ++j) {
                Node oldNode = textNodes.item(j);
                if (oldNode.getNodeType() != 3 || oldNode.getNodeValue() == null || !oldNode.getNodeValue().startsWith(I18N_PREFIX)) continue;
                Node parent = oldNode.getParentNode();
                String key = oldNode.getNodeValue().substring(I18N_PREFIX.length());
                Element newNode = dom.createElementNS(I18N_NAMESPACE, "text");
                newNode.setAttribute("key", key);
                newNode.setAttribute("catalogue", "default");
                parent.replaceChild(newNode, oldNode);
            }
        }
    }
}

