/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.text.DateFormat;
import java.util.Date;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Data
extends AbstractWingElement {
    public static final String E_TEXT = "text";
    public static final String E_TRANSLATE = "translate";
    public static final String E_PARAM = "param";
    public static final String A_CATALOGUE = "catalogue";
    public static final String A_TYPE = "type";
    public static final String A_VALUE = "value";
    private static final String TYPE_DATE = "date";
    private static final String TYPE_NUMBER = "number";
    private final Message message;
    private final String characters;

    protected Data(WingContext context, Message message) throws WingException {
        super(context);
        this.message = message;
        this.characters = null;
    }

    protected Data(WingContext context, String characters) throws WingException {
        super(context);
        this.message = null;
        this.characters = characters;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        if (this.characters != null) {
            this.sendCharacters(contentHandler, this.characters);
        } else if (this.message != null) {
            String catalogue = this.message.getCatalogue();
            Object[] dictionaryParameters = this.message.getDictionaryParameters();
            if (dictionaryParameters == null || dictionaryParameters.length == 0) {
                AttributeMap attributes = new AttributeMap();
                attributes.setNamespace(WingConstants.I18N);
                attributes.put((Object)A_CATALOGUE, (Object)catalogue);
                this.startElement(contentHandler, namespaces, WingConstants.I18N, E_TEXT, attributes);
                this.sendCharacters(contentHandler, this.message.getKey());
                this.endElement(contentHandler, namespaces, WingConstants.I18N, E_TEXT);
            } else {
                this.startElement(contentHandler, namespaces, WingConstants.I18N, E_TRANSLATE, null);
                AttributeMap attributes = new AttributeMap();
                attributes.setNamespace(WingConstants.I18N);
                attributes.put((Object)A_CATALOGUE, (Object)catalogue);
                this.startElement(contentHandler, namespaces, WingConstants.I18N, E_TEXT, attributes);
                this.sendCharacters(contentHandler, this.message.getKey());
                this.endElement(contentHandler, namespaces, WingConstants.I18N, E_TEXT);
                for (Object dictionaryParameter : dictionaryParameters) {
                    if (dictionaryParameter == null) continue;
                    this.toSAX(contentHandler, namespaces, dictionaryParameter);
                }
                this.endElement(contentHandler, namespaces, WingConstants.I18N, E_TRANSLATE);
            }
        }
    }

    private void toSAX(ContentHandler contentHandler, NamespaceSupport namespaces, Object dictionaryParameter) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.setNamespace(WingConstants.I18N);
        if (dictionaryParameter instanceof Date) {
            Date date = (Date)dictionaryParameter;
            DateFormat dateFormater = DateFormat.getDateInstance(2);
            attributes.put((Object)A_TYPE, (Object)TYPE_DATE);
            attributes.put((Object)A_VALUE, (Object)dateFormater.format(date));
        } else if (dictionaryParameter instanceof Integer) {
            Integer value = (Integer)dictionaryParameter;
            attributes.put((Object)A_TYPE, (Object)TYPE_NUMBER);
            attributes.put((Object)A_VALUE, (Object)String.valueOf(value));
        } else if (dictionaryParameter instanceof Double) {
            Double value = (Double)dictionaryParameter;
            attributes.put((Object)A_TYPE, (Object)TYPE_NUMBER);
            attributes.put((Object)A_VALUE, (Object)String.valueOf(value));
        } else if (dictionaryParameter instanceof Long) {
            Long value = (Long)dictionaryParameter;
            attributes.put((Object)A_TYPE, (Object)TYPE_NUMBER);
            attributes.put((Object)A_VALUE, (Object)String.valueOf(value));
        } else if (dictionaryParameter instanceof Short) {
            Short value = (Short)dictionaryParameter;
            attributes.put((Object)A_TYPE, (Object)TYPE_NUMBER);
            attributes.put((Object)A_VALUE, (Object)String.valueOf(value));
        } else if (dictionaryParameter instanceof Float) {
            Float value = (Float)dictionaryParameter;
            attributes.put((Object)A_TYPE, (Object)TYPE_NUMBER);
            attributes.put((Object)A_VALUE, (Object)String.valueOf(value));
        }
        this.startElement(contentHandler, namespaces, WingConstants.I18N, E_PARAM, attributes);
        this.sendCharacters(contentHandler, dictionaryParameter.toString());
        this.endElement(contentHandler, namespaces, WingConstants.I18N, E_PARAM);
    }
}

