/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.config.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.datatransferproject.config.ConfigUtils;
import org.datatransferproject.config.extension.SettingsExtension;
import org.datatransferproject.types.transfer.retry.RetryStrategyLibrary;

public class YamlSettingsExtension
implements SettingsExtension {
    private static final String EXTENSION_SETTINGS_PATH = "config/extension.yaml";
    private static final String COMMON_SETTINGS_PATH = "config/common.yaml";
    private static final String ENV_COMMON_SETTINGS_PATH = "config/env/common.yaml";
    private static final String API_SETTINGS_PATH = "config/api.yaml";
    private static final String ENV_API_SETTINGS_PATH = "config/env/api.yaml";
    private static final String RETRY_LIBRARY_PATH = "config/retry/default.yaml";
    private static final String TRANSFER_SETTINGS_PATH = "config/transfer.yaml";
    private static final String ENV_TRANSFER_SETTINGS_PATH = "config/env/transfer.yaml";
    private Map<String, Object> settings;

    public <T> T getSetting(String setting, T defaultValue) {
        if (this.settings.containsKey(setting)) {
            return (T)this.settings.get(setting);
        }
        return defaultValue;
    }

    public void initialize() {
        this.parseSimple(this.getSimpleInputStream());
        this.parseRetryLibrary(this.getRetryLibraryStream());
    }

    @VisibleForTesting
    void parseSimple(InputStream in) {
        if (in == null) {
            this.settings = new HashMap<String, Object>();
        } else {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            try {
                this.settings = (Map)mapper.readValue(in, Map.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse extension settings", e);
            }
        }
    }

    @VisibleForTesting
    void parseRetryLibrary(InputStream in) {
        if (in != null) {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            try {
                this.settings.put("retryLibrary", mapper.readValue(in, RetryStrategyLibrary.class));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse extension settings", e);
            }
        }
    }

    private InputStream getSimpleInputStream() {
        ImmutableList settingsFiles = ImmutableList.builder().add((Object)COMMON_SETTINGS_PATH).add((Object)ENV_COMMON_SETTINGS_PATH).add((Object)API_SETTINGS_PATH).add((Object)ENV_API_SETTINGS_PATH).add((Object)EXTENSION_SETTINGS_PATH).add((Object)TRANSFER_SETTINGS_PATH).add((Object)ENV_TRANSFER_SETTINGS_PATH).build();
        return ConfigUtils.getCombinedInputStream((ImmutableList)settingsFiles);
    }

    private InputStream getRetryLibraryStream() {
        return ConfigUtils.getCombinedInputStream((ImmutableList)ImmutableList.of((Object)RETRY_LIBRARY_PATH));
    }
}

