/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.mastodon.social;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.transfer.mastodon.model.Account;
import org.datatransferproject.transfer.mastodon.model.Status;
import org.datatransferproject.transfer.mastodon.social.MastodonHttpUtilities;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.social.SocialActivityActor;
import org.datatransferproject.types.common.models.social.SocialActivityContainerResource;
import org.datatransferproject.types.common.models.social.SocialActivityModel;
import org.datatransferproject.types.common.models.social.SocialActivityType;
import org.datatransferproject.types.transfer.auth.CookiesAndUrlAuthData;

public class MastodonActivityExport
implements Exporter<CookiesAndUrlAuthData, SocialActivityContainerResource> {
    private static final Pattern RAW_CONTENT_PATTERN = Pattern.compile("<p>(.*)</p>");

    public ExportResult<SocialActivityContainerResource> export(UUID jobId, CookiesAndUrlAuthData authData, Optional<ExportInformation> exportInformation) throws Exception {
        StringPaginationToken pageData;
        Preconditions.checkState((authData.getCookies().size() == 1 ? 1 : 0) != 0, (String)"Exactly 1 cookie expected: %s", (Object)authData.getCookies());
        String maxId = null;
        if (exportInformation.isPresent() && !Strings.isNullOrEmpty((String)(pageData = (StringPaginationToken)exportInformation.get().getPaginationData()).getToken())) {
            maxId = pageData.getToken();
        }
        MastodonHttpUtilities utilities = new MastodonHttpUtilities((String)authData.getCookies().get(0), authData.getUrl());
        Account account = utilities.getAccount();
        Status[] statuses = utilities.getStatuses(maxId);
        ArrayList<SocialActivityModel> activityList = new ArrayList<SocialActivityModel>(statuses.length);
        SocialActivityActor actor = new SocialActivityActor("acct:" + account.getUsername() + "@" + utilities.getHostName(), account.getDisplayName(), account.getUrl());
        ContinuationData continuationData = null;
        if (statuses.length > 0) {
            String lastId = null;
            for (Status status : statuses) {
                activityList.add(this.statusToActivity(account, status, utilities));
                lastId = status.getId();
            }
            continuationData = new ContinuationData((PaginationData)new StringPaginationToken(lastId));
        }
        return new ExportResult(continuationData == null ? ExportResult.ResultType.END : ExportResult.ResultType.CONTINUE, (DataModel)new SocialActivityContainerResource(account.getId() + maxId, actor, activityList), continuationData);
    }

    private SocialActivityModel statusToActivity(Account account, Status status, MastodonHttpUtilities utilities) {
        String contentString = status.getContent();
        Matcher matcher = RAW_CONTENT_PATTERN.matcher(contentString);
        if (matcher.matches()) {
            contentString = matcher.group(1);
        }
        return new SocialActivityModel(status.getUri(), status.getCreatedAt(), SocialActivityType.NOTE, null, null, null, contentString, status.getUrl());
    }
}

