/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.mastodon.social;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.UUID;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.mastodon.social.MastodonHttpUtilities;
import org.datatransferproject.types.common.models.social.SocialActivityContainerResource;
import org.datatransferproject.types.common.models.social.SocialActivityModel;
import org.datatransferproject.types.common.models.social.SocialActivityType;
import org.datatransferproject.types.transfer.auth.CookiesAndUrlAuthData;

public class MastodonActivityImport
implements Importer<CookiesAndUrlAuthData, SocialActivityContainerResource> {
    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentImportExecutor, CookiesAndUrlAuthData authData, SocialActivityContainerResource data) throws Exception {
        Preconditions.checkState((authData.getCookies().size() == 1 ? 1 : 0) != 0, (String)"Exactly 1 cookie expected: %s", (Object)authData.getCookies());
        MastodonHttpUtilities utilities = new MastodonHttpUtilities((String)authData.getCookies().get(0), authData.getUrl());
        for (SocialActivityModel activity : data.getActivities()) {
            if (activity.getType() != SocialActivityType.NOTE) continue;
            idempotentImportExecutor.executeAndSwallowIOExceptions(activity.getId(), activity.getContent(), () -> {
                this.postNode(activity, utilities, jobId);
                return 1;
            });
        }
        return ImportResult.OK;
    }

    private void postNode(SocialActivityModel activity, MastodonHttpUtilities utilities, UUID jobId) throws IOException {
        utilities.postStatus("Duplicated: " + activity.getContent(), jobId + activity.getId());
    }
}

