/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.mastodon.social;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.IOUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.datatransferproject.transfer.mastodon.model.Account;
import org.datatransferproject.transfer.mastodon.model.Status;

public class MastodonHttpUtilities {
    private static final String ACCOUNT_VERIFICATION_URL = "/api/v1/accounts/verify_credentials";
    private static final String STATUS_URL_PATTERN = "/api/v1/accounts/%s/statuses";
    private static final String POST_URL = "/api/v1/statuses";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final HttpTransport TRANSPORT = new NetHttpTransport();
    private final URI baseUri;
    private final String accessToken;
    private final String baseUrl;
    private final Account account;

    MastodonHttpUtilities(String accessToken, String baseUrl) throws IOException {
        this.accessToken = (String)Preconditions.checkNotNull((Object)accessToken, (Object)"accessToken must be provided");
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl must be provided");
        this.baseUri = URI.create(baseUrl);
        this.account = this.fetchAccount();
    }

    public Account getAccount() {
        return this.account;
    }

    public Status[] getStatuses(String maxId) throws Exception {
        Object url = String.format(STATUS_URL_PATTERN, this.account.getId());
        if (!Strings.isNullOrEmpty((String)maxId)) {
            url = (String)url + "?max_id=" + maxId;
        }
        return this.request((String)url, Status[].class);
    }

    public void postStatus(String content, String idempotencyKey) throws IOException {
        ImmutableMap formParams = ImmutableMap.of((Object)"status", (Object)content, (Object)"visibility", (Object)"private");
        UrlEncodedContent urlEncodedContent = new UrlEncodedContent((Object)formParams);
        HttpRequest postRequest = TRANSPORT.createRequestFactory().buildPostRequest(new GenericUrl(this.baseUrl + POST_URL), (HttpContent)urlEncodedContent).setThrowExceptionOnExecuteError(false);
        HttpHeaders headers = new HttpHeaders();
        headers.setAuthorization("Bearer " + this.accessToken);
        if (!Strings.isNullOrEmpty((String)idempotencyKey)) {
            headers.set("Idempotency-Key", (Object)idempotencyKey);
        }
        postRequest.setHeaders(headers);
        HttpResponse response = postRequest.execute();
        MastodonHttpUtilities.validateResponse(postRequest, response, 200);
    }

    private Account fetchAccount() throws IOException {
        Account accountInfo = this.request(ACCOUNT_VERIFICATION_URL, Account.class);
        return accountInfo;
    }

    private <T> T request(String path, Class<T> clazz) throws IOException {
        String rawString = this.requestRaw(path);
        try {
            return (T)OBJECT_MAPPER.readValue(rawString, clazz);
        }
        catch (IOException | RuntimeException e) {
            throw new IOException("Problem parsing results of: " + path + "\nContent: " + rawString, e);
        }
    }

    private String requestRaw(String path) throws IOException {
        HttpRequest getRequest = TRANSPORT.createRequestFactory().buildGetRequest(new GenericUrl(this.baseUrl + path));
        HttpHeaders headers = new HttpHeaders();
        headers.setAuthorization("Bearer " + this.accessToken);
        getRequest.setHeaders(headers);
        HttpResponse response = getRequest.execute();
        MastodonHttpUtilities.validateResponse(getRequest, response, 200);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)response.getContent(), (OutputStream)byteArrayOutputStream, (boolean)true);
        return byteArrayOutputStream.toString();
    }

    private static void validateResponse(HttpRequest request, HttpResponse response, int expectedCode) throws IOException {
        if (response.getStatusCode() != expectedCode) {
            throw new IOException("Unexpected return code: " + response.getStatusCode() + "\nMessage:\n" + response.getStatusMessage() + "\nfrom:\n" + request.getUrl() + "\nHeaders:\n" + response.getHeaders());
        }
    }

    public String getHostName() {
        return this.baseUri.getHost();
    }
}

