/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer;

import com.google.common.base.Stopwatch;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.JobMetadata;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.transfer.auth.AuthData;
import org.datatransferproject.types.transfer.errors.ErrorDetail;

public class CallableImporter
implements Callable<ImportResult> {
    private final Provider<Importer> importerProvider;
    private final UUID jobId;
    private final IdempotentImportExecutor idempotentImportExecutor;
    private final AuthData authData;
    private final DataModel data;
    private final DtpInternalMetricRecorder metricRecorder;

    public CallableImporter(Provider<Importer> importerProvider, UUID jobId, IdempotentImportExecutor idempotentImportExecutor, AuthData authData, DataModel data, DtpInternalMetricRecorder metricRecorder) {
        this.importerProvider = importerProvider;
        this.jobId = jobId;
        this.idempotentImportExecutor = idempotentImportExecutor;
        this.authData = authData;
        this.data = data;
        this.metricRecorder = metricRecorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportResult call() throws Exception {
        boolean success = false;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.idempotentImportExecutor.resetRecentErrors();
            ImportResult result = ((Importer)this.importerProvider.get()).importItem(this.jobId, this.idempotentImportExecutor, this.authData, this.data);
            Collection errors = this.idempotentImportExecutor.getRecentErrors();
            boolean bl = success = result.getType() == ImportResult.ResultType.OK && errors.isEmpty();
            if (!success) {
                throw new IOException("Problem with importer, forcing a retry, first error: " + (errors.iterator().hasNext() ? ((ErrorDetail)errors.iterator().next()).exception() : "none"));
            }
            ImportResult importResult = result = result.copyWithCounts(this.data.getCounts());
            return importResult;
        }
        finally {
            this.metricRecorder.importPageAttemptFinished(JobMetadata.getDataType(), JobMetadata.getImportService(), success, stopwatch.elapsed());
        }
    }
}

