/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.UUID;

public final class JobMetadata {
    private static byte[] encodedPrivateKey = null;
    private static UUID jobId = null;
    private static String dataType = null;
    private static String exportService = null;
    private static String importService = null;
    private static Stopwatch stopWatch = null;

    public static boolean isInitialized() {
        return jobId != null && encodedPrivateKey != null && dataType != null && exportService != null && importService != null && stopWatch != null;
    }

    static void init(UUID initJobId, byte[] initEncodedPrivateKey, String initDataType, String initExportService, String initImportService, Stopwatch initStopWatch) {
        Preconditions.checkState((!JobMetadata.isInitialized() ? 1 : 0) != 0, (Object)"JobMetadata cannot be initialized twice");
        jobId = initJobId;
        encodedPrivateKey = initEncodedPrivateKey;
        dataType = initDataType;
        exportService = initExportService;
        importService = initImportService;
        stopWatch = initStopWatch;
    }

    static synchronized void reset() {
        jobId = null;
        encodedPrivateKey = null;
        dataType = null;
        exportService = null;
        importService = null;
        stopWatch = null;
    }

    static byte[] getPrivateKey() {
        Preconditions.checkState((boolean)JobMetadata.isInitialized(), (Object)"JobMetadata must be initialized");
        return encodedPrivateKey;
    }

    public static UUID getJobId() {
        Preconditions.checkState((boolean)JobMetadata.isInitialized(), (Object)"JobMetadata must be initialized");
        return jobId;
    }

    public static String getDataType() {
        Preconditions.checkState((boolean)JobMetadata.isInitialized(), (Object)"JobMetadata must be initialized");
        return dataType;
    }

    public static String getExportService() {
        Preconditions.checkState((boolean)JobMetadata.isInitialized(), (Object)"JobMetadata must be initialized");
        return exportService;
    }

    public static String getImportService() {
        Preconditions.checkState((boolean)JobMetadata.isInitialized(), (Object)"JobMetadata must be initialized");
        return importService;
    }

    public static Stopwatch getStopWatch() {
        Preconditions.checkState((boolean)JobMetadata.isInitialized(), (Object)"JobMetadata must be initialized");
        return stopWatch;
    }
}

