/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.datatransferproject.api.launcher.Constants;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Flag;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.TypeManager;
import org.datatransferproject.config.extension.SettingsExtension;
import org.datatransferproject.launcher.types.TypeManagerImpl;
import org.datatransferproject.types.transfer.auth.TokenAuthData;
import org.datatransferproject.types.transfer.auth.TokenSecretAuthData;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class WorkerExtensionContext
implements ExtensionContext {
    private final TypeManager typeManager;
    private final Map<Class<?>, Object> registered = new HashMap();
    private final SettingsExtension settingsExtension;
    private final String cloud;
    private final Constants.Environment environment;
    private final Monitor monitor;

    WorkerExtensionContext(SettingsExtension settingsExtension, Monitor monitor) {
        this.monitor = monitor;
        this.typeManager = new TypeManagerImpl();
        this.typeManager.registerTypes(new Class[]{TokenAuthData.class, TokensAndUrlAuthData.class, TokenSecretAuthData.class});
        this.registered.put(TypeManager.class, this.typeManager);
        this.settingsExtension = settingsExtension;
        this.cloud = (String)settingsExtension.getSetting("cloud", null);
        Preconditions.checkNotNull((Object)this.cloud, (Object)"Required setting 'cloud' is missing");
        this.environment = Constants.Environment.valueOf((String)((String)settingsExtension.getSetting("environment", null)));
        Preconditions.checkNotNull((Object)this.environment, (Object)"Required setting 'environment' is missing");
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public <T> T getService(Class<T> type) {
        return type.cast(this.registered.get(type));
    }

    public <T> void registerService(Class<T> type, T service) {
        this.registered.put(type, service);
    }

    public <T> T getSetting(String setting, T defaultValue) {
        return (T)this.settingsExtension.getSetting(setting, defaultValue);
    }

    @Flag
    public String cloud() {
        return this.cloud;
    }

    @Flag
    public Constants.Environment environment() {
        return this.environment;
    }
}

