/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncaughtExceptionHandlers;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import java.util.ServiceLoader;
import okhttp3.OkHttpClient;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.config.extension.SettingsExtension;
import org.datatransferproject.config.extension.SettingsExtensionLoader;
import org.datatransferproject.launcher.monitor.MonitorLoader;
import org.datatransferproject.security.AesSymmetricKeyGenerator;
import org.datatransferproject.security.SymmetricKeyGenerator;
import org.datatransferproject.spi.cloud.extension.CloudExtension;
import org.datatransferproject.spi.cloud.extension.CloudExtensionLoader;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.service.extension.ServiceExtension;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.hooks.JobHooks;
import org.datatransferproject.spi.transfer.hooks.JobHooksLoader;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutorLoader;
import org.datatransferproject.spi.transfer.security.SecurityExtension;
import org.datatransferproject.spi.transfer.security.SecurityExtensionLoader;
import org.datatransferproject.transfer.JobMetadata;
import org.datatransferproject.transfer.Worker;
import org.datatransferproject.transfer.WorkerExtensionContext;
import org.datatransferproject.transfer.WorkerModule;

public class WorkerMain {
    private Worker worker;

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(UncaughtExceptionHandlers.systemExit());
        WorkerMain workerMain = new WorkerMain();
        workerMain.initialize();
        workerMain.poll();
        System.exit(0);
    }

    public void initialize() {
        Monitor monitor = MonitorLoader.loadMonitor();
        SettingsExtension settingsExtension = SettingsExtensionLoader.getSettingsExtension();
        settingsExtension.initialize();
        WorkerExtensionContext extensionContext = new WorkerExtensionContext(settingsExtension, monitor);
        extensionContext.registerService(HttpTransport.class, new NetHttpTransport());
        extensionContext.registerService(OkHttpClient.class, new OkHttpClient.Builder().build());
        extensionContext.registerService(JsonFactory.class, new JacksonFactory());
        ServiceLoader.load(ServiceExtension.class).iterator().forEachRemaining(serviceExtension -> serviceExtension.initialize((ExtensionContext)extensionContext));
        CloudExtension cloudExtension = CloudExtensionLoader.getCloudExtension();
        cloudExtension.initialize((ExtensionContext)extensionContext);
        monitor.info(() -> "Using CloudExtension: " + cloudExtension.getClass().getName(), new Object[0]);
        JobStore jobStore = cloudExtension.getJobStore();
        extensionContext.registerService(JobStore.class, jobStore);
        extensionContext.registerService(TemporaryPerJobDataStore.class, jobStore);
        AppCredentialStore appCredentialStore = cloudExtension.getAppCredentialStore();
        extensionContext.registerService(AppCredentialStore.class, appCredentialStore);
        List<TransferExtension> transferExtensions = WorkerMain.getTransferExtensions(monitor);
        SecurityExtension securityExtension = SecurityExtensionLoader.getSecurityExtension((ExtensionContext)extensionContext);
        monitor.info(() -> "Using SecurityExtension: " + securityExtension.getClass().getName(), new Object[0]);
        IdempotentImportExecutor idempotentImportExecutor = IdempotentImportExecutorLoader.load((Monitor)monitor);
        monitor.info(() -> "Using IdempotentImportExecutor: " + idempotentImportExecutor.getClass().getName(), new Object[0]);
        AesSymmetricKeyGenerator symmetricKeyGenerator = new AesSymmetricKeyGenerator(monitor);
        JobHooks jobHooks = JobHooksLoader.loadJobHooks();
        Injector injector = null;
        try {
            injector = Guice.createInjector((Module[])new Module[]{new WorkerModule(extensionContext, cloudExtension, transferExtensions, securityExtension, idempotentImportExecutor, (SymmetricKeyGenerator)symmetricKeyGenerator, jobHooks)});
        }
        catch (Exception e) {
            monitor.severe(() -> "Unable to initialize Guice in Worker", new Object[]{e});
            throw e;
        }
        this.worker = (Worker)injector.getInstance(Worker.class);
        JobMetadata.reset();
    }

    public void poll() {
        this.worker.doWork();
    }

    private static List<TransferExtension> getTransferExtensions(Monitor monitor) {
        ImmutableList.Builder extensionsBuilder = ImmutableList.builder();
        ServiceLoader.load(TransferExtension.class).iterator().forEachRemaining(ext -> {
            monitor.info(() -> "Loading transfer extension: " + ext + " for " + ext.getServiceId(), new Object[0]);
            extensionsBuilder.add(ext);
        });
        ImmutableList extensions = extensionsBuilder.build();
        Preconditions.checkState((!extensions.isEmpty() ? 1 : 0) != 0, (Object)"Could not find any implementations of TransferExtension");
        return extensions;
    }
}

