/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.datatransferproject.api.launcher.DelegatingExtensionContext;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.MetricRecorder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.config.FlagBindingModule;
import org.datatransferproject.launcher.metrics.LoggingDtpInternalMetricRecorder;
import org.datatransferproject.launcher.metrics.ServiceAwareMetricRecorder;
import org.datatransferproject.security.SymmetricKeyGenerator;
import org.datatransferproject.spi.cloud.extension.CloudExtension;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.hooks.JobHooks;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.security.AuthDataDecryptService;
import org.datatransferproject.spi.transfer.security.PublicKeySerializer;
import org.datatransferproject.spi.transfer.security.SecurityExtension;
import org.datatransferproject.spi.transfer.security.TransferKeyGenerator;
import org.datatransferproject.transfer.Annotations;
import org.datatransferproject.transfer.JobMetadata;
import org.datatransferproject.transfer.copier.InMemoryDataCopier;
import org.datatransferproject.transfer.copier.InMemoryDataCopierClassLoader;
import org.datatransferproject.types.transfer.retry.RetryStrategyLibrary;
import org.datatransferproject.types.transfer.serviceconfig.TransferServiceConfig;

final class WorkerModule
extends FlagBindingModule {
    private final CloudExtension cloudExtension;
    private final ExtensionContext context;
    private final List<TransferExtension> transferExtensions;
    private final SecurityExtension securityExtension;
    private final IdempotentImportExecutor idempotentImportExecutor;
    private final SymmetricKeyGenerator symmetricKeyGenerator;
    private final JobHooks jobHooks;

    WorkerModule(ExtensionContext context, CloudExtension cloudExtension, List<TransferExtension> transferExtensions, SecurityExtension securityExtension, IdempotentImportExecutor idempotentImportExecutor, SymmetricKeyGenerator symmetricKeyGenerator, JobHooks jobHooks) {
        this.cloudExtension = cloudExtension;
        this.context = context;
        this.transferExtensions = transferExtensions;
        this.securityExtension = securityExtension;
        this.idempotentImportExecutor = idempotentImportExecutor;
        this.symmetricKeyGenerator = symmetricKeyGenerator;
        this.jobHooks = jobHooks;
    }

    @VisibleForTesting
    static TransferExtension findTransferExtension(ImmutableList<TransferExtension> transferExtensions, String service) {
        try {
            return (TransferExtension)transferExtensions.stream().filter(ext -> ext.getServiceId().toLowerCase().equals(service.toLowerCase())).collect(MoreCollectors.onlyElement());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Found multiple transfer extensions for service " + service, e);
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Did not find a valid transfer extension for service " + service, e);
        }
    }

    protected void configure() {
        this.bindFlags(this.context);
        this.bind(JobHooks.class).toInstance((Object)this.jobHooks);
        this.bind(InMemoryDataCopier.class).to(InMemoryDataCopierClassLoader.load());
        this.getMonitor().info(() -> "Using InMemoryDataCopier: " + InMemoryDataCopierClassLoader.load().getName(), new Object[0]);
        this.bind(ObjectMapper.class).toInstance((Object)this.context.getTypeManager().getMapper());
        LoggingDtpInternalMetricRecorder.registerRecorderIfNeeded((ExtensionContext)this.context);
        this.bind(DtpInternalMetricRecorder.class).toInstance(this.context.getService(DtpInternalMetricRecorder.class));
    }

    @Provides
    @Singleton
    SymmetricKeyGenerator getSymmetricKeyGenerator() {
        return this.symmetricKeyGenerator;
    }

    @Provides
    @Singleton
    PublicKeySerializer getPublicKeySerializer() {
        return this.securityExtension.getPublicKeySerializer();
    }

    @Provides
    @Singleton
    AuthDataDecryptService getAuthDataDecryptService() {
        return this.securityExtension.getDecryptService();
    }

    @Provides
    @Singleton
    TransferKeyGenerator getTransferKeyGenerator() {
        return this.securityExtension.getTransferKeyGenerator();
    }

    @Provides
    @Singleton
    JobStore getJobStore() {
        return this.cloudExtension.getJobStore();
    }

    @Provides
    @Singleton
    AppCredentialStore getBucketStore() {
        return this.cloudExtension.getAppCredentialStore();
    }

    @Provides
    @Singleton
    Exporter getExporter(ImmutableList<TransferExtension> transferExtensions) {
        TransferExtension extension = WorkerModule.findTransferExtension(transferExtensions, JobMetadata.getExportService());
        DelegatingExtensionContext serviceSpecificContext = new DelegatingExtensionContext(this.context);
        serviceSpecificContext.registerOverrideService(MetricRecorder.class, (Object)new ServiceAwareMetricRecorder(extension.getServiceId(), (DtpInternalMetricRecorder)this.context.getService(DtpInternalMetricRecorder.class)));
        serviceSpecificContext.registerOverrideService(TransferServiceConfig.class, (Object)this.getTransferServiceConfig(extension));
        extension.initialize((ExtensionContext)serviceSpecificContext);
        return extension.getExporter(JobMetadata.getDataType());
    }

    @Provides
    @Singleton
    Importer getImporter(ImmutableList<TransferExtension> transferExtensions) {
        TransferExtension extension = WorkerModule.findTransferExtension(transferExtensions, JobMetadata.getImportService());
        DelegatingExtensionContext serviceSpecificContext = new DelegatingExtensionContext(this.context);
        serviceSpecificContext.registerOverrideService(MetricRecorder.class, (Object)new ServiceAwareMetricRecorder(extension.getServiceId(), (DtpInternalMetricRecorder)this.context.getService(DtpInternalMetricRecorder.class)));
        serviceSpecificContext.registerOverrideService(TransferServiceConfig.class, (Object)this.getTransferServiceConfig(extension));
        extension.initialize((ExtensionContext)serviceSpecificContext);
        return extension.getImporter(JobMetadata.getDataType());
    }

    @Provides
    @Singleton
    ImmutableList<TransferExtension> getTransferExtensions() {
        return ImmutableList.copyOf(this.transferExtensions);
    }

    @Provides
    @Singleton
    RetryStrategyLibrary getRetryStrategyLibrary() {
        return (RetryStrategyLibrary)this.context.getSetting("retryLibrary", null);
    }

    @Provides
    @Singleton
    AbstractScheduledService.Scheduler getScheduler() {
        long interval = ((Integer)this.context.getSetting("pollInterval", (Object)2000)).intValue();
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)interval, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Provides
    @Singleton
    @Annotations.CancelScheduler
    AbstractScheduledService.Scheduler getCancelCheckingScheduler() {
        long interval = ((Integer)this.context.getSetting("cancelCheckPollInterval", (Object)60000)).intValue();
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)interval, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Provides
    @Singleton
    Monitor getMonitor() {
        return this.context.getMonitor();
    }

    @Provides
    @Singleton
    ExtensionContext getContext() {
        return this.context;
    }

    private TransferServiceConfig getTransferServiceConfig(TransferExtension ext) {
        String configFileName = "config/" + ext.getServiceId().toLowerCase() + ".yaml";
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(configFileName);
        this.getMonitor().info(() -> String.format("Service %s has a config file: %s", ext.getServiceId(), inputStream != null), new Object[0]);
        if (inputStream == null) {
            return TransferServiceConfig.getDefaultInstance();
        }
        try {
            return TransferServiceConfig.create((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't create config for " + ext.getServiceId(), e);
        }
    }

    @Provides
    @Singleton
    public IdempotentImportExecutor getIdempotentImportExecutor() {
        return this.idempotentImportExecutor;
    }
}

