/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.copier;

import com.google.common.base.Stopwatch;
import com.google.inject.Provider;
import java.io.IOException;
import java.time.Clock;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.launcher.monitor.events.EventCode;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.CopyException;
import org.datatransferproject.spi.transfer.types.CopyExceptionWithFailureReason;
import org.datatransferproject.transfer.CallableExporter;
import org.datatransferproject.transfer.CallableImporter;
import org.datatransferproject.transfer.JobMetadata;
import org.datatransferproject.transfer.copier.InMemoryDataCopier;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.transfer.auth.AuthData;
import org.datatransferproject.types.transfer.errors.ErrorDetail;
import org.datatransferproject.types.transfer.retry.RetryException;
import org.datatransferproject.types.transfer.retry.RetryStrategyLibrary;
import org.datatransferproject.types.transfer.retry.RetryingCallable;

public abstract class PortabilityAbstractInMemoryDataCopier
implements InMemoryDataCopier {
    protected final Provider<Exporter> exporterProvider;
    protected final Provider<Importer> importerProvider;
    protected final IdempotentImportExecutor idempotentImportExecutor;
    protected final Provider<RetryStrategyLibrary> retryStrategyLibraryProvider;
    protected final Monitor monitor;
    protected final DtpInternalMetricRecorder metricRecorder;
    protected final JobStore jobStore;

    public PortabilityAbstractInMemoryDataCopier(Provider<Exporter> exporterProvider, Provider<Importer> importerProvider, Provider<RetryStrategyLibrary> retryStrategyLibraryProvider, Monitor monitor, IdempotentImportExecutor idempotentImportExecutor, DtpInternalMetricRecorder dtpInternalMetricRecorder, JobStore jobStore) {
        this.exporterProvider = exporterProvider;
        this.importerProvider = importerProvider;
        this.retryStrategyLibraryProvider = retryStrategyLibraryProvider;
        this.monitor = monitor;
        this.idempotentImportExecutor = idempotentImportExecutor;
        this.metricRecorder = dtpInternalMetricRecorder;
        this.jobStore = jobStore;
    }

    public abstract void resetCopyIterationCounter();

    @Override
    public abstract Collection<ErrorDetail> copy(AuthData var1, AuthData var2, UUID var3, Optional<ExportInformation> var4) throws IOException, CopyException;

    protected ExportResult<?> copyIteration(UUID jobId, AuthData exportAuthData, AuthData importAuthData, Optional<ExportInformation> exportInformation, String jobIdPrefix, int copyIteration) throws CopyException {
        ExportResult exportResult;
        this.monitor.debug(() -> jobIdPrefix + "Copy iteration: " + copyIteration, new Object[0]);
        RetryStrategyLibrary retryStrategyLibrary = (RetryStrategyLibrary)this.retryStrategyLibraryProvider.get();
        this.monitor.debug(() -> jobIdPrefix + "Starting export, copy iteration: " + copyIteration, new Object[]{EventCode.COPIER_STARTED_EXPORT});
        CallableExporter callableExporter = new CallableExporter(this.exporterProvider, jobId, exportAuthData, exportInformation, this.metricRecorder);
        RetryingCallable retryingExporter = new RetryingCallable((Callable)callableExporter, retryStrategyLibrary, Clock.systemUTC(), this.monitor, JobMetadata.getDataType(), JobMetadata.getExportService());
        boolean exportSuccess = false;
        Stopwatch exportStopwatch = Stopwatch.createStarted();
        try {
            exportResult = (ExportResult)retryingExporter.call();
            exportSuccess = exportResult.getType() != ExportResult.ResultType.ERROR;
        }
        catch (RuntimeException | RetryException e) {
            if (e.getClass() == RetryException.class && CopyExceptionWithFailureReason.class.isAssignableFrom(e.getCause().getClass())) {
                throw (CopyExceptionWithFailureReason)e.getCause();
            }
            throw new CopyException(jobIdPrefix + "Error happened during export", e);
        }
        finally {
            this.metricRecorder.exportPageFinished(JobMetadata.getDataType(), JobMetadata.getExportService(), exportSuccess, exportStopwatch.elapsed());
        }
        this.monitor.debug(() -> jobIdPrefix + "Finished export, copy iteration: " + copyIteration, new Object[]{EventCode.COPIER_FINISHED_EXPORT});
        if (exportResult.getExportedData() != null) {
            this.monitor.debug(() -> jobIdPrefix + "Starting import, copy iteration: " + copyIteration, new Object[]{EventCode.COPIER_STARTED_IMPORT});
            CallableImporter callableImporter = new CallableImporter(this.importerProvider, jobId, this.idempotentImportExecutor, importAuthData, exportResult.getExportedData(), this.metricRecorder);
            RetryingCallable retryingImporter = new RetryingCallable((Callable)callableImporter, retryStrategyLibrary, Clock.systemUTC(), this.monitor, JobMetadata.getDataType(), JobMetadata.getImportService());
            boolean importSuccess = false;
            Stopwatch importStopwatch = Stopwatch.createStarted();
            try {
                ImportResult importResult = (ImportResult)retryingImporter.call();
                boolean bl = importSuccess = importResult.getType() == ImportResult.ResultType.OK;
                if (importSuccess) {
                    try {
                        this.jobStore.addCounts(jobId, (Map)importResult.getCounts().orElse(null));
                        this.jobStore.addBytes(jobId, (Long)importResult.getBytes().orElse(null));
                    }
                    catch (IOException e) {
                        this.monitor.debug(() -> jobIdPrefix + "Unable to add counts to job: ", new Object[]{e});
                    }
                }
            }
            catch (RuntimeException | RetryException e) {
                if (e.getClass() == RetryException.class && CopyExceptionWithFailureReason.class.isAssignableFrom(e.getCause().getClass())) {
                    throw (CopyExceptionWithFailureReason)e.getCause();
                }
                throw new CopyException(jobIdPrefix + "Error happened during import", e);
            }
            finally {
                this.metricRecorder.importPageFinished(JobMetadata.getDataType(), JobMetadata.getImportService(), importSuccess, importStopwatch.elapsed());
            }
            this.monitor.debug(() -> jobIdPrefix + "Finished import, copy iteration: " + copyIteration, new Object[]{EventCode.COPIER_FINISHED_IMPORT});
        }
        return exportResult;
    }
}

