/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.copier;

import com.google.inject.Provider;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.spi.transfer.types.CopyException;
import org.datatransferproject.transfer.copier.InMemoryDataCopier;
import org.datatransferproject.transfer.copier.PortabilityAbstractInMemoryDataCopier;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.transfer.auth.AuthData;
import org.datatransferproject.types.transfer.errors.ErrorDetail;
import org.datatransferproject.types.transfer.retry.RetryStrategyLibrary;

public class PortabilityInMemoryDataCopier
extends PortabilityAbstractInMemoryDataCopier
implements InMemoryDataCopier {
    private static final AtomicInteger COPY_ITERATION_COUNTER = new AtomicInteger();

    @Inject
    public PortabilityInMemoryDataCopier(Provider<Exporter> exporterProvider, Provider<Importer> importerProvider, Provider<RetryStrategyLibrary> retryStrategyLibraryProvider, Monitor monitor, IdempotentImportExecutor idempotentImportExecutor, DtpInternalMetricRecorder dtpInternalMetricRecorder, JobStore jobStore) {
        super(exporterProvider, importerProvider, retryStrategyLibraryProvider, monitor, idempotentImportExecutor, dtpInternalMetricRecorder, jobStore);
    }

    @Override
    public void resetCopyIterationCounter() {
        COPY_ITERATION_COUNTER.set(0);
    }

    @Override
    public Collection<ErrorDetail> copy(AuthData exportAuthData, AuthData importAuthData, UUID jobId, Optional<ExportInformation> exportInfo) throws IOException, CopyException {
        this.idempotentImportExecutor.setJobId(jobId);
        return this.copyHelper(exportAuthData, importAuthData, jobId, exportInfo);
    }

    private Collection<ErrorDetail> copyHelper(AuthData exportAuthData, AuthData importAuthData, UUID jobId, Optional<ExportInformation> exportInfo) throws CopyException {
        int copyIteration;
        String jobIdPrefix = "Job " + jobId + ": ";
        ExportResult<?> exportResult = this.copyIteration(jobId, exportAuthData, importAuthData, exportInfo, jobIdPrefix, copyIteration = COPY_ITERATION_COUNTER.incrementAndGet());
        ContinuationData continuationData = exportResult.getContinuationData();
        if (null != continuationData) {
            if (null != continuationData.getPaginationData()) {
                this.monitor.debug(() -> jobIdPrefix + "Starting off a new copy iteration with pagination info, copy iteration: " + copyIteration, new Object[0]);
                this.copyHelper(exportAuthData, importAuthData, jobId, Optional.of(new ExportInformation(continuationData.getPaginationData(), exportInfo.isPresent() ? exportInfo.get().getContainerResource() : null)));
            }
            if (continuationData.getContainerResources() != null && !continuationData.getContainerResources().isEmpty()) {
                for (ContainerResource resource : continuationData.getContainerResources()) {
                    this.monitor.debug(() -> jobIdPrefix + "Starting off a new copy iteration with a new container resource, copy iteration: " + copyIteration, new Object[0]);
                    this.copyHelper(exportAuthData, importAuthData, jobId, Optional.of(new ExportInformation(null, resource)));
                }
            }
        }
        return this.idempotentImportExecutor.getErrors();
    }
}

