/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transport.jettyrest.rest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.Servlet;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.spi.api.transport.TransportBinder;
import org.datatransferproject.transport.jettyrest.http.JettyTransport;
import org.datatransferproject.transport.jettyrest.rest.DataTypesController;
import org.datatransferproject.transport.jettyrest.rest.TransferController;
import org.datatransferproject.transport.jettyrest.rest.TransferServicesController;
import org.datatransferproject.types.client.datatype.DataTypes;
import org.datatransferproject.types.client.datatype.GetDataTypes;
import org.datatransferproject.types.client.transfer.CreateTransferJob;
import org.datatransferproject.types.client.transfer.GenerateServiceAuthData;
import org.datatransferproject.types.client.transfer.GetReservedWorker;
import org.datatransferproject.types.client.transfer.GetTransferJob;
import org.datatransferproject.types.client.transfer.GetTransferServices;
import org.datatransferproject.types.client.transfer.ReserveWorker;
import org.datatransferproject.types.client.transfer.ReservedWorker;
import org.datatransferproject.types.client.transfer.ServiceAuthData;
import org.datatransferproject.types.client.transfer.StartTransferJob;
import org.datatransferproject.types.client.transfer.TransferJob;
import org.datatransferproject.types.client.transfer.TransferServices;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class JerseyTransportBinder
implements TransportBinder {
    private final JettyTransport jettyTransport;
    private final Map<Class<?>, Action> actions;

    public JerseyTransportBinder(JettyTransport jettyTransport) {
        this.jettyTransport = jettyTransport;
        this.actions = new HashMap();
    }

    public <T> void bind(Action<T, ?> action) {
        this.actions.put(action.getRequestType(), action);
    }

    public void start() {
        try {
            HashSet<Object> controllers = new HashSet<Object>();
            controllers.add(new DataTypesController((Action<GetDataTypes, DataTypes>)this.actions.get(GetDataTypes.class)));
            controllers.add(new TransferServicesController((Action<GetTransferServices, TransferServices>)this.actions.get(GetTransferServices.class)));
            controllers.add(new TransferController((Action<CreateTransferJob, TransferJob>)this.actions.get(CreateTransferJob.class), (Action<GenerateServiceAuthData, ServiceAuthData>)this.actions.get(GenerateServiceAuthData.class), (Action<ReserveWorker, ReservedWorker>)this.actions.get(ReserveWorker.class), (Action<GetReservedWorker, ReservedWorker>)this.actions.get(GetReservedWorker.class), (Action<StartTransferJob, TransferJob>)this.actions.get(StartTransferJob.class), (Action<GetTransferJob, TransferJob>)this.actions.get(GetTransferJob.class)));
            ResourceConfig resourceConfig = new ResourceConfig();
            resourceConfig.registerInstances(controllers);
            ServletContainer servletContainer = new ServletContainer(resourceConfig);
            this.jettyTransport.registerServlet("/api/*", (Servlet)servletContainer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

