/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transport.jettyrest.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.types.client.transfer.CreateTransferJob;
import org.datatransferproject.types.client.transfer.GenerateServiceAuthData;
import org.datatransferproject.types.client.transfer.GetReservedWorker;
import org.datatransferproject.types.client.transfer.GetTransferJob;
import org.datatransferproject.types.client.transfer.ReserveWorker;
import org.datatransferproject.types.client.transfer.ReservedWorker;
import org.datatransferproject.types.client.transfer.ServiceAuthData;
import org.datatransferproject.types.client.transfer.StartTransferJob;
import org.datatransferproject.types.client.transfer.TransferJob;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/transfer")
public class TransferController {
    private final Action<CreateTransferJob, TransferJob> createJobAction;
    private final Action<GenerateServiceAuthData, ServiceAuthData> generateAuthDataAction;
    private final Action<ReserveWorker, ReservedWorker> reserveWorkerAction;
    private final Action<GetReservedWorker, ReservedWorker> getReservedWorkerAction;
    private final Action<StartTransferJob, TransferJob> startJobAction;
    private final Action<GetTransferJob, TransferJob> getJobAction;

    public TransferController(Action<CreateTransferJob, TransferJob> createJobAction, Action<GenerateServiceAuthData, ServiceAuthData> generateAuthDataAction, Action<ReserveWorker, ReservedWorker> reserveWorkerAction, Action<GetReservedWorker, ReservedWorker> getReservedWorkerAction, Action<StartTransferJob, TransferJob> startJobAction, Action<GetTransferJob, TransferJob> getJobAction) {
        this.createJobAction = createJobAction;
        this.generateAuthDataAction = generateAuthDataAction;
        this.reserveWorkerAction = reserveWorkerAction;
        this.getReservedWorkerAction = getReservedWorkerAction;
        this.startJobAction = startJobAction;
        this.getJobAction = getJobAction;
    }

    @GET
    @Path(value="{id}")
    public TransferJob getTransferJob(@PathParam(value="id") String id) {
        return (TransferJob)this.getJobAction.handle((Object)new GetTransferJob(id));
    }

    @POST
    public TransferJob createTransferJob(CreateTransferJob request) {
        return (TransferJob)this.createJobAction.handle((Object)request);
    }

    @POST
    @Path(value="{id}/generate")
    public ServiceAuthData generate(GenerateServiceAuthData generate) {
        return (ServiceAuthData)this.generateAuthDataAction.handle((Object)generate);
    }

    @POST
    @Path(value="worker/{id}")
    public ReservedWorker reserveWorker(ReserveWorker reserveWorker) {
        return (ReservedWorker)this.reserveWorkerAction.handle((Object)reserveWorker);
    }

    @GET
    @Path(value="worker/{id}")
    public ReservedWorker getWorker(@PathParam(value="id") String id) {
        return (ReservedWorker)this.getReservedWorkerAction.handle((Object)new GetReservedWorker(id));
    }

    @POST
    @Path(value="{id}/start")
    public TransferJob startTransferJob(StartTransferJob request) {
        return (TransferJob)this.startJobAction.handle((Object)request);
    }
}

